within AixLib.Systems.ModularAHU.Validation.MeasuredData;
record AHU2_Preheater_RampValve
  "Ramp of the 3-way-valve of the preheater (mixing circuit) with maximal pump frequency"

  parameter Real AC_3000[:,:]=[
 0,52.34,56.9,15.29,14.87,10.92,17.21,3047.03,3.41,0.0,15.48,16.16,0.0,3420;
10,52.27,56.8,15.09,14.68,10.91,17.04,3012.1,3.54,0.0,15.18,15.93,0.0,3422;
20,52.24,56.7,14.49,14.12,10.91,16.91,2960.58,3.45,0.0,14.88,15.76,0.0,3441;
30,52.16,56.5,14.15,13.78,10.91,16.76,3040.9,3.42,0.0,14.62,15.55,0.58,3419;
40,52.13,56.4,14.01,13.65,10.91,16.63,3057.57,3.38,0.0,14.38,15.37,0.58,3409;
50,52.07,56.3,13.6,13.25,10.91,16.51,2973.91,3.47,0.0,14.17,15.19,0.0,3459;
60,52.01,56.2,13.44,13.09,10.92,16.34,3047.26,3.39,0.0,13.96,15.07,0.0,3430;
70,51.98,56.1,13.16,12.83,10.91,16.17,2966.63,3.45,0.0,13.75,14.92,0.0,3412;
80,51.89,56.0,12.92,12.61,10.9,15.97,3012.18,3.52,0.0,13.57,14.8,0.86,3425;
90,51.84,55.8,12.79,12.5,10.9,15.83,3052.82,3.33,0.0,13.42,14.64,1.15,3452;
100,51.79,55.7,12.64,12.35,10.9,15.83,3028.61,3.37,0.0,13.24,14.52,1.15,3414;
110,51.74,55.6,12.55,12.25,10.89,15.57,2986.0,3.33,0.0,13.1,14.41,1.29,3406;
120,51.69,55.3,12.34,12.05,10.89,15.46,3048.9,3.4,0.0,12.98,14.28,1.44,3441;
130,51.63,55.2,12.22,11.96,10.88,15.31,2964.9,3.42,0.0,12.87,14.19,1.44,3439;
140,51.58,55.1,12.16,11.86,10.88,15.2,2977.02,3.39,0.0,12.75,14.1,1.44,3467;
150,51.54,55.0,11.99,11.71,10.87,15.11,3009.95,3.49,0.0,12.66,13.99,1.73,3424;
161,51.48,54.9,11.95,11.68,10.88,14.97,3068.81,3.39,0.0,12.54,13.9,1.73,3416;
170,51.42,54.7,11.86,11.57,10.88,14.88,3011.29,3.31,0.0,12.44,13.81,2.3,3402;
180,51.37,54.6,11.75,11.45,10.88,14.77,2978.92,3.42,0.0,12.38,13.72,2.3,3406;
190,51.35,54.5,11.65,11.41,10.88,14.68,3038.54,3.37,0.0,12.29,13.66,2.3,3397;
200,51.28,54.3,11.63,11.35,10.87,14.58,2950.71,3.43,0.0,12.22,13.56,2.3,3459;
210,51.23,54.3,11.53,11.29,10.86,14.52,2961.15,3.86,0.0,12.13,13.5,2.73,3429;
220,51.17,54.1,11.5,11.25,10.86,14.43,3031.78,3.78,0.0,12.08,13.44,2.73,3422;
231,51.11,54.0,11.45,11.17,10.87,14.39,2951.99,3.69,0.0,12.01,13.36,3.02,3414;
240,51.08,53.9,11.38,11.14,10.87,14.26,2989.85,3.83,0.0,11.97,13.31,3.02,3408;
250,51.02,53.8,11.36,11.09,10.87,14.2,2931.86,3.83,0.0,11.92,13.25,3.02,3401;
260,50.99,53.7,11.3,11.02,10.87,14.13,2968.11,3.74,0.0,11.86,13.17,3.45,3412;
270,50.93,53.5,11.27,11.02,10.87,14.07,3015.76,3.8,0.0,11.81,13.14,3.45,3476;
280,50.88,53.4,11.23,10.99,10.87,14.03,3019.73,3.82,0.0,11.78,13.08,3.45,3412;
290,50.83,53.2,11.21,10.94,10.87,13.95,2973.89,3.77,0.0,11.73,13.01,3.74,3429;
301,50.78,53.1,11.18,10.9,10.86,13.9,3001.29,3.8,0.0,11.7,12.96,3.74,3426;
310,50.71,53.0,11.12,10.88,10.86,13.84,3017.46,3.84,0.0,11.68,12.92,4.17,3405;
320,50.67,52.8,11.1,10.87,10.86,13.79,3011.48,3.82,0.0,11.63,12.89,4.17,3409;
330,50.64,52.7,11.09,10.85,10.85,13.77,2967.35,3.62,0.0,11.59,12.85,4.17,3426;
340,50.58,52.7,11.09,10.83,10.85,13.7,2979.79,3.77,0.0,11.58,12.83,4.32,3411;
351,50.52,52.5,11.06,10.8,10.85,13.67,2977.6,3.8,0.0,11.53,12.76,4.6,3449;
361,50.47,52.4,11.03,10.77,10.85,13.63,2979.66,3.88,0.0,11.53,12.75,4.6,3448;
371,50.43,52.3,11.0,10.76,10.84,13.58,2973.35,3.76,0.0,11.49,12.69,4.6,3397;
380,50.4,52.2,10.97,10.73,10.85,13.56,2992.89,3.79,0.0,11.48,12.67,5.04,3445;
391,50.35,52.1,10.96,10.71,10.85,13.53,2994.94,3.75,0.0,11.43,12.63,5.04,3431;
401,50.31,52.0,10.95,10.7,10.85,13.51,3053.94,3.7,0.0,11.42,12.6,5.32,3430;
410,50.25,51.9,10.95,10.68,10.86,13.45,2961.35,3.86,0.0,11.4,12.59,5.32,3430;
421,50.19,51.8,10.95,10.67,10.86,13.42,3008.24,3.81,0.0,11.38,12.57,5.61,3407;
430,50.15,51.7,10.93,10.65,10.85,13.39,3008.78,3.6,0.0,11.35,12.52,5.61,3468;
441,50.12,51.6,10.92,10.63,10.85,13.35,2985.52,3.87,0.0,11.33,12.5,5.61,3407;
451,50.07,51.5,10.89,10.61,10.85,13.33,3039.85,3.83,0.0,11.31,12.45,6.04,3411;
461,50.02,51.4,10.88,10.61,10.85,13.32,2937.71,3.7,0.0,11.28,12.41,6.04,3401;
470,49.96,51.3,10.86,10.6,10.85,13.27,2996.11,3.76,0.0,11.28,12.4,6.47,3459;
480,49.92,51.2,10.85,10.6,10.85,13.24,3020.54,3.71,0.0,11.27,12.36,6.47,3430;
491,49.87,51.0,10.84,10.6,10.85,13.22,3004.07,3.78,0.0,11.25,12.32,6.47,3408;
500,49.83,51.0,10.84,10.59,10.85,13.2,2955.2,3.79,0.0,11.22,12.31,6.62,3447;
511,49.78,50.9,10.83,10.59,10.85,13.17,3001.12,3.79,0.0,11.24,12.29,6.62,3430;
520,49.74,50.8,10.82,10.58,10.86,13.16,3045.25,3.83,0.0,11.21,12.26,6.91,3415;
531,49.71,50.7,10.82,10.58,10.85,13.13,3011.82,3.81,0.0,11.2,12.24,7.19,3411;
541,49.64,50.6,10.81,10.57,10.85,13.11,3025.23,3.85,0.0,11.17,12.22,7.19,3435;
551,49.6,50.4,10.82,10.57,10.85,13.09,2972.16,3.63,0.0,11.15,12.2,7.19,3427;
560,49.58,50.3,10.82,10.56,10.85,13.07,2977.93,3.78,0.0,11.16,12.19,7.48,3425;
570,49.53,50.2,10.81,10.56,10.85,13.05,2982.07,3.83,0.0,11.14,12.16,7.48,3400;
581,49.48,50.1,10.81,10.55,10.85,13.02,3014.67,3.71,0.0,11.13,12.14,7.77,3417;
590,49.42,50.1,10.81,10.54,10.84,13.0,3023.03,3.76,0.0,11.11,12.13,7.91,3425;
601,49.39,50.0,10.8,10.53,10.84,12.98,2989.14,3.76,0.0,11.1,12.11,7.91,3423;
611,49.33,49.9,10.8,10.53,10.85,12.97,2995.03,3.77,0.0,11.1,12.08,8.2,3395;
620,49.28,49.8,10.79,10.52,10.85,12.96,3012.63,3.8,0.0,11.08,12.08,8.06,3400;
631,49.25,49.7,10.79,10.52,10.85,12.94,2959.46,3.76,0.0,11.06,12.04,8.49,3453;
641,49.21,49.6,10.79,10.51,10.85,12.93,2985.72,3.61,0.0,11.06,12.05,8.49,3450;
651,49.16,49.5,10.78,10.5,10.86,12.91,3012.98,3.72,0.0,11.05,12.02,8.78,3416;
661,49.11,49.4,10.77,10.49,10.86,12.9,3046.95,3.97,0.0,11.04,11.99,8.78,3406;
671,49.09,49.3,10.78,10.5,10.86,12.88,3056.64,3.75,0.0,11.04,11.99,9.21,3413;
681,49.05,49.2,10.77,10.49,10.86,12.87,2983.87,3.68,0.0,11.04,11.99,9.06,3419;
691,48.99,49.1,10.77,10.48,10.86,12.85,2983.89,3.66,0.0,11.03,11.95,9.35,3409;
701,48.98,49.0,10.77,10.48,10.87,12.84,3064.09,3.8,0.0,11.03,11.95,9.35,3412;
711,48.92,48.9,10.74,10.47,10.86,12.83,3006.58,3.71,0.0,11.01,11.94,9.5,3413;
721,48.88,48.8,10.74,10.47,10.86,12.81,3005.83,3.74,0.0,11.01,11.91,9.93,3445;
731,48.83,48.7,10.74,10.47,10.86,12.8,3015.13,3.71,0.0,10.99,11.91,9.93,3413;
741,48.79,48.6,10.74,10.47,10.86,12.79,2981.85,3.81,0.0,10.99,11.88,9.93,3441;
751,48.74,48.5,10.75,10.47,10.86,12.78,3011.89,3.78,0.0,10.98,11.86,10.07,3410;
761,48.69,48.4,10.74,10.47,10.87,12.77,3041.44,3.75,0.0,10.98,11.84,10.36,3418;
771,48.67,48.3,10.74,10.48,10.87,12.75,2989.79,3.75,0.0,10.97,11.86,10.36,3406;
780,48.65,48.2,10.73,10.47,10.87,12.74,3019.92,3.78,0.0,10.98,11.83,10.36,3439;
791,48.6,48.1,10.73,10.47,10.87,12.72,2982.12,3.71,0.0,10.97,11.81,10.79,3409;
801,48.55,48.1,10.73,10.47,10.87,12.71,2977.16,3.81,0.0,10.94,11.79,10.79,3412;
811,48.5,48.0,10.73,10.47,10.87,12.7,3004.11,3.75,0.0,10.94,11.81,10.79,3412;
821,48.45,47.9,10.73,10.47,10.88,12.7,2987.66,3.69,0.0,10.94,11.78,11.08,3427;
831,48.4,47.8,10.73,10.47,10.88,12.68,3001.3,3.73,0.0,10.94,11.77,11.08,3419;
841,48.38,47.7,10.74,10.47,10.87,12.67,2964.0,3.71,0.0,10.94,11.76,11.51,3415;
851,48.35,47.6,10.73,10.47,10.87,12.67,3020.92,3.73,0.0,10.94,11.75,11.51,3446;
861,48.3,47.5,10.72,10.46,10.87,12.67,3049.14,3.81,0.0,10.92,11.73,11.65,3450;
871,48.27,47.4,10.72,10.47,10.87,12.66,2975.7,3.7,0.0,10.92,11.73,11.65,3437;
881,48.23,47.3,10.72,10.47,10.88,12.65,3040.77,3.79,0.0,10.92,11.72,12.09,3441;
891,48.19,47.3,10.72,10.47,10.88,12.64,2992.4,3.72,0.0,10.9,11.71,12.09,3449;
901,48.13,47.2,10.72,10.47,10.88,12.64,3045.57,3.7,0.0,10.92,11.7,12.09,3415;
911,48.1,47.1,10.72,10.46,10.88,12.63,2987.61,3.72,0.0,10.92,11.7,12.23,3445;
921,48.06,47.0,10.72,10.47,10.89,12.62,3035.41,3.83,0.0,10.9,11.68,12.37,3468;
931,48.02,46.9,10.72,10.46,10.89,12.61,3042.95,3.66,0.0,10.89,11.66,12.81,3455;
941,47.98,46.8,10.72,10.47,10.88,12.6,3001.53,3.74,0.0,10.89,11.66,12.66,3409;
951,47.95,46.8,10.71,10.47,10.88,12.59,2963.34,3.66,0.0,10.89,11.66,12.95,3452;
961,47.91,46.7,10.71,10.46,10.87,12.58,3021.5,3.7,0.0,10.88,11.64,12.95,3417;
971,47.85,46.6,10.71,10.47,10.87,12.58,2970.32,3.84,0.0,10.89,11.64,13.24,3450;
981,47.82,46.5,10.71,10.47,10.87,12.57,3035.37,3.69,0.0,10.88,11.62,13.24,3462;
991,47.78,46.4,10.71,10.47,10.87,12.56,2981.87,3.71,0.0,10.87,11.62,13.53,3429;
1001,47.75,46.4,10.71,10.47,10.87,12.56,3027.36,3.79,0.0,10.85,11.62,13.53,3419;
1011,47.68,46.3,10.72,10.47,10.88,12.55,2996.99,3.67,0.0,10.87,11.6,13.81,3458;
1021,47.67,46.2,10.72,10.47,10.88,12.55,3014.13,3.71,0.0,10.88,11.6,13.81,3457;
1031,47.63,46.1,10.72,10.47,10.89,12.54,2975.47,3.71,0.0,10.88,11.59,13.81,3417;
1041,47.58,46.1,10.72,10.47,10.88,12.53,3001.12,3.72,0.0,10.87,11.59,14.24,3410;
1051,47.53,46.0,10.72,10.47,10.89,12.52,2983.56,3.69,0.0,10.85,11.6,14.24,3417;
1061,47.51,45.9,10.73,10.47,10.89,12.52,2989.08,3.83,0.0,10.87,11.57,14.24,3417;
1071,47.46,45.8,10.73,10.47,10.89,12.51,3008.21,3.74,0.0,10.87,11.57,14.68,3422;
1081,47.41,45.7,10.72,10.47,10.89,12.5,2967.15,3.76,0.0,10.87,11.57,14.68,3451;
1091,47.39,45.7,10.73,10.47,10.89,12.49,3011.03,3.7,0.0,10.85,11.55,14.68,3432;
1101,47.35,45.6,10.72,10.47,10.89,12.5,3007.4,3.73,0.0,10.87,11.55,14.96,3430;
1111,47.31,45.5,10.73,10.47,10.9,12.49,3058.4,3.88,0.0,10.85,11.55,14.96,3460;
1121,47.28,45.5,10.72,10.47,10.9,12.49,2990.19,3.79,0.0,10.87,11.52,15.25,3446;
1131,47.25,45.4,10.73,10.47,10.9,12.48,3004.66,3.72,0.0,10.87,11.52,15.68,3419;
1141,47.19,45.3,10.72,10.47,10.9,12.47,2977.62,3.7,0.0,10.83,11.52,15.68,3418;
1151,47.15,45.2,10.72,10.47,10.91,12.47,2991.05,3.65,0.0,10.83,11.51,15.68,3421;
1161,47.12,45.1,10.73,10.47,10.91,12.47,3001.8,3.74,0.0,10.83,11.51,15.97,3438;
1171,47.08,45.1,10.72,10.47,10.91,12.46,2975.78,3.71,0.0,10.83,11.52,15.97,3437;
1181,47.01,45.0,10.73,10.47,10.91,12.45,3021.76,3.74,0.0,10.83,11.51,15.97,3423;
1191,46.98,44.9,10.72,10.47,10.91,12.45,2949.94,3.77,0.0,10.83,11.51,16.4,3430;
1201,46.93,44.9,10.72,10.47,10.91,12.45,3037.81,3.8,0.0,10.83,11.5,16.4,3420;
1212,46.91,44.8,10.72,10.47,10.9,12.46,2970.78,3.75,0.0,10.83,11.5,16.4,3457;
1221,46.87,44.7,10.72,10.47,10.91,12.45,3032.07,3.8,0.0,10.82,11.49,16.69,3445;
1231,46.84,44.6,10.73,10.47,10.91,12.45,3028.47,3.8,0.0,10.83,11.48,16.69,3416;
1241,46.8,44.6,10.72,10.47,10.92,12.44,2991.92,3.65,0.0,10.83,11.46,16.83,3441;
1251,46.75,44.5,10.72,10.47,10.92,12.43,3009.3,3.76,0.0,10.83,11.46,16.98,3441;
1261,46.74,44.4,10.72,10.47,10.93,12.42,2994.52,3.66,0.0,10.83,11.45,17.27,3431;
1271,46.69,44.4,10.73,10.47,10.93,12.41,2961.93,3.75,0.0,10.83,11.45,17.27,3438;
1281,46.64,44.3,10.73,10.47,10.93,12.4,3015.46,3.76,0.0,10.82,11.45,17.55,3437;
1291,46.59,44.2,10.73,10.47,10.93,12.4,3031.49,3.71,0.0,10.83,11.45,17.55,3425;
1301,46.55,44.2,10.72,10.47,10.93,12.4,2986.32,3.85,0.0,10.83,11.45,17.99,3425;
1311,46.53,44.1,10.73,10.47,10.92,12.4,3001.05,3.73,0.0,10.82,11.43,17.99,3437;
1321,46.47,44.1,10.73,10.47,10.92,12.4,3008.12,3.69,0.0,10.83,11.45,17.99,3427;
1331,46.44,44.0,10.73,10.47,10.91,12.4,2999.13,3.7,0.0,10.82,11.45,18.27,3445;
1341,46.41,44.0,10.72,10.47,10.91,12.4,2970.83,3.78,0.0,10.82,11.44,18.27,3422;
1352,46.37,43.9,10.73,10.47,10.92,12.4,3044.41,3.79,0.0,10.83,11.41,18.56,3437;
1361,46.32,43.9,10.72,10.47,10.92,12.39,2965.18,3.71,0.0,10.82,11.43,18.56,3423;
1371,46.25,43.9,10.73,10.47,10.92,12.39,2967.29,3.74,0.0,10.82,11.41,18.85,3433;
1382,46.23,43.9,10.74,10.47,10.92,12.39,2949.67,3.67,0.0,10.82,11.44,18.85,3450;
1391,46.14,43.9,10.77,10.47,10.92,12.39,2992.2,3.72,0.0,10.82,11.4,19.28,3453;
1402,46.06,44.0,10.78,10.48,10.92,12.38,2946.04,3.8,0.0,10.81,11.39,19.28,3420;
1411,45.98,44.0,10.78,10.48,10.93,12.38,3030.57,3.77,0.0,10.83,11.41,19.28,3429;
1422,45.92,44.1,10.81,10.51,10.93,12.38,2995.65,3.66,0.0,10.83,11.44,19.28,3422;
1431,45.83,44.1,10.82,10.53,10.94,12.38,3033.97,3.74,0.0,10.83,11.44,19.57,3426;
1442,45.77,44.1,10.83,10.56,10.94,12.38,2995.4,3.78,0.01,10.85,11.43,19.42,3418;
1451,45.66,44.2,10.84,10.57,10.94,12.38,3029.38,3.76,0.01,10.87,11.43,20.0,3424;
1461,45.57,44.2,10.88,10.59,10.93,12.38,3009.59,3.78,0.01,10.89,11.43,20.0,3417;
1472,45.48,44.3,10.92,10.61,10.94,12.39,3000.48,3.85,0.01,10.92,11.43,20.0,3427;
1481,45.35,44.3,10.95,10.62,10.93,12.39,2998.99,3.77,0.01,10.93,11.44,20.29,3417;
1492,45.27,44.4,10.97,10.67,10.94,12.4,3013.5,3.75,0.01,10.94,11.45,20.29,3423;
1502,45.15,44.6,11.02,10.7,10.93,12.41,3018.03,3.79,0.01,10.98,11.46,20.72,3424;
1511,45.04,44.7,11.07,10.74,10.93,12.42,2967.82,3.77,0.01,11.01,11.46,20.72,3424;
1522,44.91,44.8,11.1,10.77,10.93,12.43,3006.83,3.74,0.01,11.03,11.49,20.72,3428;
1531,44.78,45.0,11.14,10.83,10.93,12.44,2952.4,3.75,0.01,11.05,11.5,21.01,3426;
1542,44.66,45.2,11.16,10.85,10.93,12.46,2980.91,3.73,0.01,11.08,11.51,21.01,3428;
1551,44.52,45.5,11.23,10.88,10.93,12.47,3068.4,3.79,0.01,11.1,11.52,21.44,3425;
1562,44.38,45.8,11.24,10.88,10.93,12.47,2993.94,3.7,0.01,11.14,11.55,21.29,3427;
1571,44.24,45.9,11.27,10.94,10.92,12.48,3045.33,3.77,0.01,11.15,11.55,21.58,3428;
1581,44.11,46.1,11.28,10.97,10.92,12.5,2981.95,3.78,0.01,11.17,11.55,21.58,3432;
1592,43.94,46.3,11.34,10.99,10.92,12.51,3023.36,3.74,0.01,11.19,11.6,21.87,3424;
1601,43.8,46.6,11.37,11.02,10.92,12.52,2935.92,3.76,0.01,11.21,11.59,22.16,3433;
1612,43.6,46.7,11.38,11.03,10.92,12.53,2992.98,3.73,0.01,11.21,11.61,22.16,3429;
1621,43.44,47.0,11.39,11.04,10.92,12.55,3020.18,3.72,0.01,11.24,11.61,22.16,3434;
1632,43.26,47.3,11.42,11.07,10.93,12.56,3018.2,3.71,0.01,11.25,11.65,22.16,3431;
1642,43.05,47.5,11.45,11.1,10.93,12.57,3028.63,3.69,0.01,11.28,11.65,22.45,3430;
1651,42.82,47.6,11.48,11.12,10.93,12.58,2983.07,3.73,0.01,11.31,11.66,22.88,3436;
1662,42.58,48.0,11.48,11.12,10.93,12.59,3024.7,3.68,0.01,11.31,11.67,22.88,3434;
1671,42.27,48.2,11.52,11.15,10.94,12.6,2993.58,3.71,0.02,11.32,11.67,22.88,3433;
1682,41.93,48.5,11.52,11.17,10.94,12.61,3014.96,3.73,0.01,11.33,11.68,22.88,3434;
1692,41.55,48.8,11.53,11.17,10.95,12.62,3016.28,3.72,0.02,11.36,11.7,23.17,3435;
1702,41.18,49.0,11.55,11.19,10.95,12.63,3016.69,3.7,0.02,11.37,11.7,23.17,3437;
1711,40.79,49.3,11.61,11.23,10.95,12.64,3071.58,3.68,0.02,11.38,11.71,23.6,3438;
1721,40.43,49.5,11.62,11.23,10.95,12.65,2985.14,3.7,0.02,11.42,11.75,23.6,3432;
1732,40.07,49.8,11.65,11.27,10.96,12.66,2928.57,3.69,0.02,11.42,11.73,23.88,3440;
1741,39.69,50.1,11.66,11.29,10.96,12.67,2989.2,3.7,0.02,11.44,11.73,23.88,3441;
1752,39.38,50.4,11.67,11.3,10.96,12.69,3031.53,3.69,0.02,11.46,11.75,23.88,3438;
1761,39.07,50.6,11.71,11.31,10.96,12.69,3012.82,3.68,0.02,11.47,11.78,24.32,3439;
1772,38.78,51.0,11.75,11.34,10.95,12.71,2968.49,3.66,0.02,11.49,11.77,24.32,3441;
1782,38.51,51.3,11.77,11.36,10.96,12.72,2978.96,3.68,0.02,11.49,11.78,24.32,3444;
1791,38.23,51.6,11.8,11.4,10.96,12.73,2974.81,3.7,0.02,11.54,11.81,24.6,3444;
1802,37.88,51.9,11.81,11.43,10.96,12.75,2985.07,3.66,0.02,11.56,11.81,24.6,3445;
1811,37.51,52.3,11.87,11.44,10.96,12.75,2988.35,3.69,0.02,11.57,11.82,25.04,3447;
1822,37.07,52.9,11.91,11.45,10.96,12.76,2997.31,3.66,0.02,11.62,11.83,24.89,3446;
1832,36.52,53.3,11.94,11.51,10.96,12.78,3038.26,3.71,0.02,11.64,11.86,25.04,3446;
1842,35.87,53.7,11.96,11.55,10.96,12.8,2977.73,3.64,0.02,11.65,11.87,25.04,3450;
1852,35.1,54.2,11.98,11.56,10.97,12.81,3011.07,3.63,0.02,11.69,11.89,25.32,3448;
1861,34.14,54.6,12.06,11.58,10.96,12.83,3022.85,3.64,0.03,11.7,11.92,25.61,3447;
1872,33.05,55.2,12.1,11.65,10.97,12.85,3018.9,3.65,0.03,11.74,11.93,25.76,3448;
1882,31.9,55.7,12.16,11.69,10.97,12.86,2983.92,3.67,0.03,11.78,11.94,25.61,3451;
1892,30.63,56.2,12.21,11.72,10.97,12.88,2964.85,3.64,0.03,11.81,11.97,25.9,3449;
1902,29.25,56.8,12.24,11.78,10.97,12.9,2993.68,3.65,0.03,11.86,11.99,25.9,3449;
1912,27.78,57.2,12.34,11.84,10.97,12.93,3042.49,3.63,0.03,11.89,12.02,26.19,3448;
1922,26.26,57.8,12.39,11.87,10.97,12.95,2973.51,3.61,0.03,11.92,12.04,26.62,3453;
1932,24.83,58.0,12.49,11.97,10.97,12.97,3001.9,3.63,0.03,11.97,12.08,26.62,3453;
1942,23.54,58.5,12.51,11.99,10.97,13.0,2982.22,3.61,0.03,12.05,12.1,26.62,3450;
1951,22.27,59.0,12.64,12.1,10.97,13.01,3011.29,3.62,0.04,12.08,12.14,26.91,3454;
1962,21.09,59.3,12.67,12.12,10.97,13.05,2927.57,3.64,0.04,12.14,12.19,26.91,3454;
1972,20.0,59.8,12.77,12.19,10.97,13.07,3006.48,3.61,0.04,12.22,12.22,26.91,3454;
1982,18.99,60.1,12.9,12.27,10.97,13.11,3010.71,3.64,0.04,12.28,12.25,27.34,3455;
1992,18.03,60.5,13.02,12.38,10.97,13.14,2963.32,3.61,0.04,12.34,12.29,27.34,3457;
2002,17.34,60.9,13.07,12.44,10.97,13.17,3016.12,3.64,0.04,12.4,12.33,27.34,3455;
2012,16.63,61.4,13.2,12.55,10.97,13.23,3051.4,3.65,0.04,12.5,12.37,27.63,3458;
2022,16.12,61.6,13.32,12.64,10.97,13.25,3009.26,3.63,0.04,12.56,12.45,27.63,3461;
2032,15.69,61.9,13.44,12.73,10.97,13.31,2992.48,3.59,0.05,12.64,12.48,27.91,3462;
2042,15.32,62.3,13.59,12.86,10.97,13.36,2993.69,3.59,0.05,12.73,12.53,27.91,3463;
2052,15.09,62.6,13.72,12.95,10.97,13.4,2989.82,3.63,0.05,12.83,12.6,28.2,3461;
2062,14.94,62.8,13.87,13.11,10.97,13.47,3006.7,3.62,0.05,12.94,12.66,28.63,3463;
2072,14.73,63.0,13.95,13.17,10.97,13.52,2964.25,3.62,0.05,13.03,12.73,28.63,3464;
2082,14.56,63.4,14.13,13.31,10.97,13.59,2976.35,3.6,0.05,13.15,12.78,28.63,3464;
2092,14.47,63.5,14.32,13.51,10.97,13.61,2949.16,3.6,0.06,13.26,12.85,28.63,3466;
2102,14.38,63.7,14.42,13.56,10.97,13.72,3003.93,3.64,0.06,13.36,12.94,28.92,3471;
2112,14.3,63.9,14.68,13.77,10.97,13.77,3002.4,3.6,0.06,13.48,13.03,28.92,3468;
2122,14.11,63.9,14.82,13.89,10.97,13.83,3006.96,3.59,0.07,13.62,13.08,29.35,3472;
2132,14.15,63.9,15.0,14.04,10.97,13.89,3033.23,3.6,0.07,13.74,13.19,29.35,3470;
2142,14.2,63.9,15.21,14.23,10.97,13.97,2967.26,3.6,0.07,13.85,13.26,29.35,3472;
2152,14.12,63.9,15.36,14.36,10.97,14.08,2995.07,3.58,0.07,13.99,13.33,29.64,3473;
2162,14.08,63.9,15.57,14.51,10.97,14.14,2965.48,3.61,0.07,14.13,13.43,29.64,3475;
2172,14.17,63.9,15.87,14.76,10.97,14.21,2956.8,3.57,0.08,14.28,13.54,30.07,3477;
2182,14.22,64.0,16.02,14.89,10.98,14.32,3023.35,3.58,0.08,14.44,13.63,30.07,3477;
2192,14.29,64.0,16.23,15.07,10.98,14.35,2973.44,3.59,0.08,14.58,13.73,30.07,3481;
2202,14.36,64.1,16.34,15.18,10.98,14.5,3037.63,3.58,0.08,14.72,13.83,30.36,3482;
2212,14.5,64.0,16.64,15.43,10.98,14.58,3016.34,3.55,0.09,14.87,13.94,30.5,3486;
2222,14.61,64.0,16.74,15.49,10.99,14.66,2996.72,3.56,0.09,15.03,14.04,30.5,3485;
2232,14.78,64.1,17.09,15.8,10.99,14.79,3023.33,3.54,0.09,15.19,14.15,30.79,3487;
2242,14.9,64.1,17.29,15.95,10.99,14.86,2977.97,3.56,0.09,15.35,14.26,30.79,3485;
2252,15.06,64.2,17.47,16.11,10.99,15.0,3026.08,3.59,0.1,15.51,14.36,30.79,3493;
2262,15.2,64.2,17.76,16.37,10.99,15.0,2986.17,3.55,0.1,15.69,14.47,31.08,3489;
2272,15.42,64.3,17.96,16.54,10.98,15.21,2979.8,3.55,0.11,15.85,14.57,31.51,3492;
2282,15.6,64.4,18.15,16.69,10.98,15.31,2949.74,3.56,0.11,16.04,14.69,31.51,3495;
2292,15.76,64.5,18.44,16.92,10.99,15.43,2986.69,3.56,0.11,16.2,14.81,31.51,3493;
2302,15.94,64.6,18.72,17.18,10.99,15.55,3025.5,3.57,0.11,16.38,14.95,31.51,3495;
2312,16.15,64.7,18.88,17.32,10.99,15.64,2969.72,3.53,0.12,16.55,15.03,31.8,3499;
2322,16.3,64.8,19.05,17.43,10.99,15.71,3033.39,3.54,0.12,16.75,15.18,31.8,3498;
2332,16.53,65.0,19.52,17.81,11.0,15.89,3019.37,3.5,0.12,16.92,15.32,32.23,3498;
2342,16.74,65.1,19.73,17.99,11.0,16.04,2968.6,3.55,0.13,17.1,15.46,32.09,3504;
2352,16.94,65.2,20.0,18.24,11.0,16.16,3016.16,3.53,0.13,17.29,15.6,32.52,3506;
2362,17.16,65.3,20.24,18.41,11.0,16.23,2942.64,3.52,0.13,17.5,15.72,32.52,3505;
2372,17.38,65.5,20.55,18.69,11.01,16.42,3002.48,3.54,0.14,17.67,15.87,32.52,3505;
2382,17.64,65.6,20.67,18.81,11.01,16.51,3026.27,3.5,0.14,17.89,16.0,32.95,3508;
2392,17.89,65.7,21.05,19.1,11.01,16.66,2974.42,3.5,0.14,18.1,16.14,32.95,3510;
2402,18.08,65.8,21.37,19.39,11.01,16.8,3034.35,3.5,0.14,18.29,16.28,32.81,3506;
2412,18.36,65.9,21.49,19.5,11.01,16.97,3029.0,3.52,0.15,18.49,16.42,33.24,3511;
2422,18.57,66.0,21.86,19.82,11.01,17.04,3039.19,3.49,0.15,18.69,16.55,33.24,3513;
2432,18.81,66.1,22.04,19.98,11.01,17.22,2935.32,3.51,0.16,18.87,16.68,33.67,3514;
2442,19.06,66.2,22.19,20.08,11.0,17.37,3040.17,3.5,0.16,19.11,16.81,33.67,3515;
2452,19.27,66.3,22.67,20.52,11.0,17.49,2965.67,3.51,0.16,19.28,16.96,33.67,3514;
2462,19.49,66.3,22.83,20.68,11.0,17.58,2975.27,3.49,0.16,19.5,17.12,33.96,3521;
2472,19.72,66.4,23.1,20.87,11.01,17.79,3032.88,3.48,0.16,19.67,17.28,33.96,3522;
2482,19.97,66.5,23.34,21.09,11.01,17.91,3015.62,3.45,0.17,19.87,17.4,34.39,3524;
2492,20.23,66.6,23.63,21.32,11.01,18.07,3038.69,3.5,0.17,20.05,17.55,34.39,3520;
2502,20.46,66.6,23.75,21.43,11.01,18.21,3026.36,3.46,0.17,20.23,17.68,34.39,3524;
2512,20.67,66.6,24.03,21.7,11.01,18.38,2962.84,3.45,0.18,20.42,17.82,34.68,3531;
2522,20.91,66.6,24.24,21.85,11.02,18.54,2992.59,3.45,0.18,20.63,17.94,34.68,3527;
2532,21.11,66.6,24.53,22.1,11.03,18.63,2958.26,3.45,0.19,20.82,18.1,35.11,3533;
2542,21.32,66.6,24.85,22.33,11.03,18.81,3023.01,3.46,0.19,21.02,18.26,35.11,3532;
2552,21.57,66.6,25.06,22.55,11.03,18.93,2996.83,3.44,0.19,21.22,18.42,35.11,3532;
2562,21.76,66.6,25.26,22.72,11.03,19.08,3002.49,3.45,0.19,21.41,18.56,35.11,3532;
2573,21.99,66.6,25.39,22.85,11.02,19.21,3009.37,3.44,0.2,21.58,18.7,35.4,3536;
2582,22.2,66.4,25.69,23.11,11.02,19.4,2987.6,3.4,0.2,21.78,18.83,35.83,3539;
2592,22.43,66.2,25.89,23.25,11.03,19.49,3049.79,3.44,0.21,21.94,18.97,35.83,3536;
2602,22.59,66.0,26.1,23.4,11.03,19.63,3020.46,3.42,0.21,22.12,19.08,35.83,3540;
2612,22.81,65.7,26.39,23.68,11.04,19.79,2987.89,3.43,0.21,22.3,19.19,36.12,3543;
2622,23.01,65.4,26.6,23.86,11.05,19.89,2972.64,3.46,0.22,22.47,19.36,35.97,3544;
2632,23.19,65.1,26.71,23.96,11.05,20.07,2958.6,3.44,0.22,22.63,19.5,36.12,3542;
2642,23.4,64.7,26.85,24.11,11.05,20.19,3041.46,3.4,0.22,22.75,19.63,36.55,3546;
2652,23.58,64.4,27.04,24.24,11.05,20.36,2995.95,3.42,0.22,22.91,19.74,36.55,3548;
2663,23.73,64.0,27.16,24.38,11.05,20.46,3005.84,3.41,0.23,23.05,19.85,36.55,3543;
2672,23.88,63.6,27.29,24.51,11.05,20.57,2974.93,3.37,0.23,23.19,19.98,36.83,3547;
2683,24.01,63.1,27.43,24.59,11.05,20.71,3040.71,3.39,0.24,23.31,20.09,36.83,3548;
2692,24.15,62.8,27.54,24.7,11.05,20.76,2931.15,3.35,0.24,23.41,20.19,37.27,3553;
2702,24.27,62.4,27.7,24.81,11.06,20.96,2994.67,3.39,0.24,23.52,20.28,37.27,3555;
2713,24.42,62.1,27.81,24.93,11.06,21.05,3012.31,3.38,0.24,23.62,20.4,37.27,3558;
2722,24.53,61.7,27.92,25.03,11.06,21.15,2998.2,3.36,0.25,23.73,20.48,37.55,3562;
2733,24.62,61.6,27.99,25.05,11.06,21.29,2998.0,3.39,0.25,23.84,20.56,37.55,3556;
2742,24.73,61.3,28.09,25.13,11.06,21.36,3016.95,3.33,0.26,23.92,20.66,37.55,3567;
2753,24.82,61.1,28.24,25.24,11.07,21.49,2957.44,3.33,0.26,24.04,20.75,37.99,3565;
2763,24.9,60.9,28.34,25.36,11.07,21.57,2976.01,3.34,0.26,24.14,20.83,37.99,3563;
2772,25.0,60.8,28.49,25.46,11.06,21.65,3033.27,3.35,0.27,24.21,20.91,38.27,3568;
2782,25.11,60.7,28.6,25.51,11.06,21.77,2974.69,3.34,0.27,24.3,20.99,38.27,3568;
2792,25.21,60.7,28.69,25.62,11.06,21.8,2946.25,3.32,0.28,24.39,21.09,38.71,3574;
2803,25.3,60.7,28.88,25.74,11.06,21.95,3057.09,3.34,0.28,24.53,21.19,38.71,3575;
2812,25.42,60.6,29.05,25.91,11.07,22.02,2964.73,3.33,0.28,24.62,21.28,38.71,3575;
2823,25.54,60.6,29.09,25.94,11.07,22.11,3004.27,3.33,0.29,24.74,21.39,38.71,3578;
2832,25.64,60.5,29.27,26.06,11.07,22.22,3025.07,3.31,0.29,24.85,21.5,38.99,3577;
2842,25.75,60.6,29.37,26.17,11.08,22.29,3041.98,3.32,0.3,24.94,21.57,38.99,3577;
2853,25.84,60.6,29.5,26.24,11.08,22.4,2980.22,3.27,0.3,25.08,21.67,39.42,3585;
2862,25.96,60.6,29.62,26.32,11.08,22.4,2994.62,3.27,0.3,25.15,21.78,39.42,3585;
2873,26.08,60.8,29.85,26.53,11.09,22.59,3020.22,3.31,0.31,25.29,21.85,39.71,3588;
2882,26.2,60.8,30.05,26.64,11.09,22.68,3031.63,3.28,0.31,25.44,21.95,39.71,3584;
2893,26.34,61.0,30.21,26.8,11.09,22.76,3004.54,3.27,0.32,25.55,22.06,39.71,3588;
2903,26.49,61.0,30.46,27.0,11.09,22.88,3012.89,3.28,0.32,25.67,22.17,40.14,3594;
2913,26.65,61.2,30.52,27.03,11.09,22.96,3027.99,3.27,0.32,25.79,22.28,40.14,3595;
2923,26.77,61.3,30.73,27.22,11.09,23.1,3027.24,3.29,0.32,25.96,22.37,40.14,3595;
2932,26.92,61.4,30.88,27.37,11.1,23.18,3008.49,3.22,0.33,26.08,22.49,40.58,3593;
2943,27.09,61.6,31.06,27.46,11.1,23.31,3010.45,3.23,0.34,26.25,22.59,40.58,3594;
2952,27.21,61.7,31.31,27.67,11.1,23.41,3001.54,3.28,0.34,26.39,22.72,40.58,3596;
2963,27.37,61.8,31.55,27.87,11.1,23.46,3010.86,3.24,0.34,26.56,22.83,40.86,3605;
2973,27.56,61.9,31.71,27.99,11.11,23.66,2952.99,3.21,0.35,26.7,22.98,40.86,3606;
2982,27.74,62.1,31.83,28.1,11.11,23.74,3001.67,3.2,0.36,26.88,23.1,41.15,3607;
2993,27.89,62.2,32.25,28.41,11.11,23.86,2992.61,3.25,0.36,27.06,23.21,41.15,3605;
3002,28.08,62.4,32.43,28.6,11.1,23.99,2976.5,3.21,0.36,27.23,23.33,41.58,3611;
3013,28.29,62.6,32.69,28.81,11.11,24.12,2986.37,3.22,0.36,27.39,23.46,41.58,3608;
3023,28.45,62.7,32.86,28.96,11.11,24.18,2980.23,3.21,0.36,27.58,23.58,41.58,3611;
3033,28.62,62.8,33.09,29.16,11.12,24.33,3024.99,3.21,0.37,27.72,23.74,41.58,3614;
3043,28.82,62.8,33.18,29.25,11.12,24.47,2987.77,3.21,0.37,27.9,23.86,41.87,3618;
3052,28.98,63.0,33.45,29.44,11.13,24.57,3007.87,3.23,0.38,28.05,23.98,42.3,3620;
3063,29.14,63.1,33.72,29.65,11.13,24.65,3009.3,3.2,0.38,28.18,24.11,42.3,3619;
3073,29.32,63.4,33.82,29.75,11.13,24.84,2993.51,3.19,0.38,28.33,24.23,42.3,3615;
3082,29.49,63.6,34.08,29.97,11.14,24.93,2957.89,3.17,0.39,28.53,24.34,42.59,3625;
3092,29.66,63.6,34.3,30.11,11.14,25.05,2984.07,3.21,0.39,28.71,24.5,42.59,3625;
3103,29.81,63.8,34.37,30.18,11.14,25.23,2998.64,3.19,0.39,28.91,24.64,42.59,3623;
3113,30.0,64.0,34.74,30.51,11.15,25.34,3011.08,3.21,0.4,29.04,24.76,43.02,3628;
3122,30.19,64.1,34.94,30.64,11.16,25.46,2992.11,3.2,0.4,29.19,24.89,43.02,3628;
3132,30.33,64.3,35.09,30.78,11.16,25.62,3008.84,3.17,0.41,29.36,25.03,43.02,3632;
3142,30.52,64.4,35.31,30.96,11.16,25.74,3019.42,3.19,0.41,29.5,25.17,43.31,3631;
3153,30.7,64.5,35.54,31.1,11.16,25.84,3081.59,3.16,0.42,29.68,25.28,43.74,3637;
3163,30.9,64.7,35.78,31.26,11.16,25.95,2981.18,3.16,0.43,29.89,25.42,43.74,3636;
3173,31.08,65.1,36.15,31.57,11.16,26.1,2991.44,3.17,0.43,30.1,25.55,43.74,3637;
3183,31.32,65.2,36.34,31.77,11.16,26.27,3021.61,3.18,0.44,30.31,25.7,44.03,3641;
3193,31.53,65.4,36.7,32.01,11.17,26.39,3043.89,3.17,0.44,30.51,25.85,44.03,3639;
3203,31.75,65.5,36.85,32.14,11.17,26.57,2979.89,3.15,0.45,30.72,26.01,44.03,3642;
3213,32.0,65.7,37.25,32.45,11.18,26.7,3004.95,3.12,0.45,30.93,26.19,44.46,3641;
3223,32.17,65.9,37.51,32.66,11.18,26.82,2938.46,3.14,0.45,31.14,26.35,44.46,3642;
3233,32.43,66.2,37.65,32.8,11.18,27.0,3034.47,3.15,0.46,31.33,26.5,44.46,3644;
3243,32.65,66.4,38.04,33.09,11.18,27.12,3024.49,3.12,0.46,31.54,26.63,44.75,3642;
3253,32.82,66.5,38.26,33.27,11.19,27.28,2971.92,3.13,0.46,31.74,26.78,44.75,3643;
3263,33.05,66.8,38.48,33.48,11.19,27.43,2960.51,3.11,0.48,31.95,26.96,45.18,3651;
3273,33.28,66.8,38.82,33.7,11.19,27.63,2973.41,3.12,0.48,32.17,27.1,45.18,3650;
3283,33.54,66.9,39.07,33.89,11.2,27.81,3005.74,3.12,0.49,32.4,27.27,45.18,3649;
3293,33.77,67.0,39.36,34.17,11.2,27.94,2999.54,3.11,0.49,32.66,27.44,45.47,3649;
3303,34.01,67.1,39.68,34.41,11.2,28.14,3012.55,3.13,0.5,32.86,27.61,45.47,3652;
3313,34.25,67.0,40.04,34.68,11.21,28.27,3018.46,3.09,0.51,33.08,27.77,45.9,3654;
3323,34.47,67.4,40.3,34.88,11.21,28.44,3025.08,3.1,0.51,33.3,27.95,45.9,3654;
3333,34.73,67.5,40.55,35.14,11.21,28.51,2974.03,3.12,0.51,33.54,28.09,45.9,3652;
3343,34.94,67.7,40.87,35.38,11.21,28.83,3056.29,3.09,0.53,33.76,28.25,46.19,3657;
3353,35.16,68.1,41.14,35.58,11.21,29.01,3010.47,3.1,0.52,33.96,28.42,46.19,3661;
3363,35.39,68.0,41.42,35.83,11.21,29.08,2945.22,3.08,0.53,34.16,28.58,46.19,3658;
3373,35.61,68.3,41.76,36.07,11.22,29.28,3006.94,3.07,0.54,34.4,28.75,46.62,3661;
3383,35.84,68.2,41.84,36.15,11.23,29.52,2985.35,3.07,0.54,34.61,28.91,46.47,3655;
3393,36.07,68.5,42.12,36.42,11.23,29.66,2984.39,3.08,0.55,34.83,29.11,46.47,3660;
3403,36.31,68.2,42.33,36.63,11.24,29.83,2983.38,3.1,0.55,35.04,29.28,46.91,3646;
3413,36.49,68.6,42.64,36.81,11.24,29.97,3003.09,3.09,0.55,35.26,29.45,46.91,3650;
3423,36.71,68.4,42.89,37.06,11.25,30.24,2990.46,3.07,0.58,35.42,29.62,47.34,3655;
3433,36.91,68.6,43.32,37.28,11.26,30.34,2977.44,3.06,0.58,35.66,29.78,47.34,3659;
3443,37.14,68.7,43.53,37.51,11.26,30.5,3036.08,3.06,0.59,35.88,29.93,47.34,3658;
3453,37.42,69.0,43.87,37.8,11.26,30.66,2949.49,3.05,0.6,36.12,30.14,47.63,3664;
3463,37.67,68.9,44.24,38.07,11.26,30.87,3010.43,3.05,0.61,36.4,30.31,47.63,3663;
3473,37.95,68.9,44.53,38.28,11.25,31.05,2937.29,3.04,0.62,36.62,30.5,48.06,3664;
3483,38.21,69.0,44.86,38.42,11.26,31.24,3030.76,3.07,0.62,36.88,30.69,48.06,3662;
3493,38.46,69.1,45.05,38.8,11.25,31.4,2970.58,3.06,0.63,37.12,30.86,48.35,3670;
3503,38.66,68.9,45.44,39.04,11.25,31.64,3024.06,3.05,0.64,37.37,31.02,48.35,3666;
3513,38.89,69.0,45.57,39.19,11.25,31.78,3037.74,3.03,0.64,37.59,31.19,48.35,3667;
3523,39.14,69.0,45.85,39.47,11.25,32.0,3019.53,3.05,0.66,37.76,31.39,48.78,3670;
3533,39.36,69.1,46.16,39.62,11.26,32.12,2972.39,3.05,0.67,37.97,31.58,48.78,3672;
3543,39.57,69.2,46.4,39.84,11.26,32.39,2981.76,3.05,0.68,38.24,31.74,48.78,3673;
3553,39.81,69.2,46.83,40.16,11.27,32.58,3014.47,3.04,0.69,38.43,31.91,49.06,3674;
3563,40.04,69.3,47.08,40.37,11.27,32.77,2990.29,3.02,0.7,38.69,32.07,49.06,3679;
3573,40.31,69.3,47.34,40.58,11.27,32.96,2973.72,3.04,0.71,38.93,32.26,49.5,3675;
3583,40.55,69.3,47.75,40.93,11.28,33.09,2969.38,3.03,0.71,39.17,32.46,49.5,3677;
3593,40.84,69.3,47.95,41.14,11.29,33.26,2963.18,3.01,0.71,39.38,32.62,49.5,3649;
3603,41.01,69.1,48.09,41.3,11.3,33.45,2994.8,3.02,0.73,39.55,32.81,49.78,3657;
3613,41.17,69.2,48.35,41.42,11.3,33.68,2972.83,3.02,0.75,39.75,32.98,49.78,3656;
3623,41.39,69.1,48.78,41.69,11.3,33.85,2972.71,3.01,0.77,39.98,33.12,50.22,3659;
3633,41.66,69.2,48.9,41.76,11.3,33.96,3017.46,2.99,0.77,40.21,33.3,50.22,3657;
3643,41.92,68.9,49.25,42.12,11.3,34.19,2958.97,3.03,0.77,40.44,33.48,50.22,3653;
3653,42.12,69.0,49.44,42.44,11.31,34.34,3017.41,3.02,0.79,40.68,33.65,50.5,3658;
3663,42.28,68.9,49.63,42.5,11.31,34.51,2955.03,3.01,0.8,40.87,33.85,50.5,3659;
3673,42.53,68.8,49.96,42.78,11.31,34.69,2981.75,3.02,0.82,41.04,34.01,50.94,3659;
3683,42.72,68.6,50.2,42.94,11.31,34.82,2974.81,2.98,0.82,41.29,34.16,50.94,3656;
3694,42.92,68.5,50.33,43.1,11.32,35.0,2986.44,2.99,0.82,41.47,34.3,50.94,3655;
3703,43.05,68.4,50.42,43.22,11.32,35.28,2979.38,2.99,0.83,41.58,34.44,50.94,3659;
3714,43.14,68.3,50.61,43.37,11.32,35.4,2986.01,3.0,0.84,41.76,34.57,51.22,3658;
3723,43.28,68.4,50.69,43.47,11.32,35.56,2984.68,3.01,0.88,41.91,34.73,51.65,3661;
3733,43.38,68.4,51.08,43.59,11.32,35.74,3007.52,3.01,0.89,42.09,34.87,51.65,3660;
3744,43.64,68.2,51.36,43.89,11.32,35.87,2990.17,2.97,0.89,42.28,35.02,51.65,3659;
3753,43.85,68.1,51.49,44.06,11.32,36.0,2975.78,3.01,0.89,42.46,35.19,51.65,3661;
3763,44.01,68.0,51.56,44.15,11.32,36.11,3023.88,2.95,0.9,42.61,35.35,51.94,3660;
3773,44.11,67.9,51.74,44.31,11.33,36.3,3017.92,2.98,0.92,42.75,35.53,51.94,3657;
3784,44.23,67.9,51.92,44.44,11.33,36.51,2979.63,2.99,0.93,42.87,35.64,52.37,3656;
3793,44.34,67.9,52.06,44.51,11.34,36.61,3020.23,2.97,0.93,43.01,35.77,52.37,3657;
3803,44.47,67.9,52.18,44.67,11.34,36.77,2944.93,2.98,0.93,43.16,35.91,52.37,3658;
3813,44.57,67.9,52.36,44.78,11.33,36.87,2981.95,2.97,0.95,43.28,36.03,52.66,3658;
3823,44.66,67.9,52.45,44.87,11.33,36.98,3014.12,2.99,0.95,43.38,36.14,52.66,3659;
3834,44.81,67.8,52.59,44.99,11.33,37.13,2949.75,2.97,0.97,43.49,36.26,53.09,3663;
3844,44.95,67.9,52.77,45.07,11.33,37.24,3023.49,2.98,0.97,43.65,36.35,53.09,3664;
3854,45.08,67.9,52.87,45.2,11.33,37.36,3002.99,2.97,0.99,43.78,36.44,53.09,3660;
3864,45.18,68.0,53.15,45.37,11.33,37.46,2977.43,2.95,1.0,43.96,36.58,53.38,3667;
3873,45.35,67.9,53.31,45.51,11.34,37.62,3042.67,2.98,1.02,44.07,36.7,53.81,3669;
3883,45.51,68.0,53.39,45.59,11.34,37.79,2952.69,2.98,1.02,44.21,36.86,53.81,3663;
3893,45.68,68.1,53.72,45.87,11.34,37.87,3023.83,3.0,1.02,44.36,37.01,53.81,3667;
3904,45.83,68.1,53.85,46.0,11.35,38.02,2992.19,2.96,1.03,44.51,37.12,53.81,3662;
3914,45.94,68.1,53.96,46.07,11.36,38.13,2995.51,2.96,1.05,44.66,37.25,54.1,3669;
3924,46.1,68.2,54.21,46.22,11.36,38.25,2941.21,2.98,1.05,44.83,37.39,54.1,3670;
3933,46.25,68.3,54.48,46.44,11.37,38.38,3046.9,2.97,1.07,44.98,37.52,54.53,3670;
3943,46.43,68.5,54.59,46.54,11.37,38.53,2997.26,2.98,1.07,45.16,37.66,54.53,3671;
3954,46.61,68.4,54.83,46.75,11.38,38.67,2969.44,2.96,1.08,45.35,37.8,54.53,3676;
3963,46.76,68.5,54.95,46.86,11.38,38.72,3034.79,2.96,1.09,45.55,37.93,54.82,3676;
3974,46.91,68.5,55.26,47.07,11.39,38.91,3006.12,2.96,1.1,45.7,38.03,54.82,3673;
3983,47.07,68.6,55.4,47.24,11.38,39.07,2899.66,2.95,1.11,45.83,38.14,55.25,3669;
3994,47.2,68.6,55.53,47.31,11.38,39.18,3083.43,2.98,1.12,45.98,38.26,55.25,3679;
4004,47.35,68.6,55.74,47.52,11.38,39.31,2973.2,2.96,1.12,46.15,38.39,55.25,3680;
4013,47.48,68.7,55.85,47.66,11.38,39.42,3010.92,2.95,1.13,46.25,38.5,55.25,3681;
4024,47.58,68.6,56.0,47.73,11.38,39.6,3000.8,2.97,1.14,46.4,38.65,55.54,3683;
4033,47.7,68.6,56.12,47.81,11.38,39.66,3037.36,2.95,1.15,46.52,38.77,55.54,3681;
4044,47.82,68.6,56.27,47.94,11.39,39.82,2942.16,2.95,1.16,46.62,38.91,55.97,3680;
4054,47.94,68.7,56.44,48.08,11.39,39.89,2965.5,2.97,1.16,46.74,39.04,55.97,3682;
4064,48.05,68.7,56.51,48.15,11.4,40.02,2966.8,2.94,1.17,46.85,39.19,55.97,3680;
4073,48.11,68.6,56.64,48.27,11.4,40.13,3026.66,2.96,1.18,46.95,39.28,56.26,3685;
4084,48.23,68.6,56.79,48.34,11.4,40.24,2982.65,2.94,1.2,47.1,39.37,56.26,3685;
4094,48.34,68.6,56.97,48.46,11.4,40.32,2984.2,2.92,1.21,47.19,39.49,56.69,3687;
4103,48.45,68.6,57.09,48.6,11.4,40.43,2982.98,2.91,1.21,47.34,39.58,56.69,3682;
4114,48.57,68.5,57.2,48.7,11.4,40.54,2982.49,2.94,1.22,47.46,39.7,56.69,3685;
4123,48.66,68.4,57.3,48.81,11.4,40.67,2987.9,2.91,1.23,47.56,39.8,56.98,3690;
4134,48.77,68.4,57.36,48.83,11.4,40.78,3014.72,2.95,1.23,47.67,39.89,56.98,3689;
4144,48.84,68.3,57.48,48.97,11.4,40.86,3023.6,2.96,1.25,47.75,40.0,57.41,3688;
4154,48.88,68.3,57.62,48.98,11.4,40.97,2991.51,2.95,1.26,47.77,40.1,57.27,3695;
4164,48.95,68.2,57.65,49.08,11.4,41.07,3029.07,2.93,1.26,47.87,40.17,57.41,3688;
4174,48.98,68.2,57.67,49.13,11.4,41.18,2966.29,2.93,1.28,47.94,40.25,57.7,3694;
4184,49.04,68.1,57.73,49.16,11.4,41.25,3016.18,2.94,1.29,48.03,40.34,57.7,3693;
4194,49.17,68.0,57.92,49.3,11.4,41.39,2941.33,2.92,1.31,48.08,40.4,57.99,3696;
4204,49.22,67.8,58.01,49.33,11.41,41.46,2998.78,2.91,1.32,48.19,40.5,58.13,3697;
4214,49.33,67.8,58.09,49.46,11.41,41.57,3012.01,2.93,1.32,48.3,40.62,58.13,3693;
4224,49.37,67.7,58.09,49.51,11.42,41.68,3007.25,2.92,1.34,48.33,40.71,58.42,3695;
4234,49.39,67.8,58.17,49.52,11.42,41.73,2942.67,2.94,1.34,48.42,40.74,58.42,3696;
4244,49.47,67.7,58.3,49.55,11.42,41.83,3000.33,2.92,1.36,48.55,40.82,58.85,3695;
4254,49.58,67.6,58.36,49.66,11.42,41.92,3011.46,2.94,1.36,48.6,40.91,58.85,3698;
4264,49.59,67.4,58.38,49.7,11.41,41.99,3013.22,2.93,1.36,48.66,41.0,58.85,3697;
4274,49.58,67.3,58.37,49.73,11.42,42.06,2984.07,2.95,1.38,48.71,41.06,59.14,3696;
4284,49.59,67.2,58.38,49.71,11.42,42.11,2984.0,2.91,1.38,48.71,41.09,59.14,3697;
4294,49.6,67.3,58.39,49.74,11.42,42.19,2977.15,2.93,1.41,48.74,41.15,59.57,3697;
4304,49.67,67.3,58.52,49.76,11.44,42.28,3000.61,2.93,1.41,48.76,41.22,59.57,3696;
4314,49.72,67.3,58.6,49.82,11.45,42.33,2995.15,2.93,1.41,48.84,41.29,59.57,3696;
4324,49.78,67.2,58.63,49.9,11.45,42.4,2990.9,2.92,1.43,48.91,41.36,59.86,3695;
4334,49.86,67.2,58.73,49.97,11.45,42.46,3008.44,2.9,1.43,49.01,41.44,59.86,3695;
4344,49.89,67.0,58.74,49.99,11.45,42.51,3016.08,2.93,1.44,49.03,41.48,59.86,3697;
4354,49.91,67.0,58.78,50.05,11.44,42.57,2986.99,2.94,1.46,49.07,41.5,60.29,3700;
4364,49.97,66.9,58.91,50.07,11.45,42.62,3066.28,2.92,1.46,49.16,41.54,60.29,3698;
4374,50.05,67.0,58.92,50.14,11.45,42.69,2994.57,2.91,1.48,49.2,41.64,60.58,3698;
4383,50.03,66.9,59.02,50.18,11.45,42.79,2984.12,2.89,1.48,49.22,41.69,60.58,3696;
4394,50.1,66.8,59.08,50.22,11.46,42.83,2999.09,2.91,1.5,49.27,41.8,61.01,3695;
4404,50.17,66.8,59.18,50.28,11.45,42.92,2993.17,2.91,1.51,49.35,41.86,61.01,3701;
4414,50.25,66.9,59.23,50.33,11.46,42.99,3060.04,2.93,1.51,49.39,41.89,61.01,3701;
4424,50.29,66.8,59.28,50.38,11.47,43.06,3025.9,2.92,1.52,49.44,41.94,60.86,3696;
4434,50.32,66.8,59.34,50.44,11.47,43.12,2996.64,2.92,1.54,49.52,42.04,61.29,3697;
4444,50.42,66.8,59.47,50.51,11.48,43.19,3003.24,2.89,1.55,49.58,42.1,61.29,3699;
4454,50.48,66.8,59.59,50.6,11.48,43.23,3032.64,2.91,1.56,49.69,42.21,61.73,3699;
4464,50.58,66.9,59.63,50.66,11.48,43.28,2935.45,2.91,1.56,49.72,42.25,61.73,3701;
4474,50.66,66.8,59.75,50.75,11.49,43.32,2997.0,2.89,1.56,49.85,42.32,61.73,3701;
4484,50.71,66.9,59.77,50.8,11.48,43.4,3013.68,2.91,1.58,49.9,42.39,62.01,3696;
4494,50.71,66.8,59.89,50.84,11.48,43.46,3020.45,2.9,1.58,50.0,42.46,62.01,3699;
4504,50.82,67.0,59.9,50.87,11.48,43.51,2966.5,2.9,1.61,50.05,42.49,62.45,3695;
4514,50.92,67.1,60.11,50.92,11.47,43.56,3021.7,2.9,1.61,50.16,42.57,62.45,3700;
4524,51.06,67.1,60.34,51.11,11.48,43.63,2997.36,2.91,1.62,50.23,42.66,62.45,3699;
4534,51.15,67.2,60.41,51.21,11.49,43.71,2992.5,2.89,1.63,50.37,42.79,62.73,3695;
4544,51.26,67.2,60.51,51.27,11.49,43.81,3047.56,2.9,1.63,50.48,42.86,62.73,3701;
4554,51.37,67.3,60.72,51.47,11.49,43.86,2969.28,2.87,1.65,50.56,42.95,63.17,3701;
4564,51.48,67.4,60.89,51.51,11.49,43.96,2991.71,2.9,1.66,50.71,43.05,63.17,3698;
4574,51.62,67.4,61.04,51.64,11.5,44.07,3032.3,2.91,1.66,50.81,43.12,63.17,3699;
4584,51.73,67.5,61.14,51.78,11.5,44.16,2999.85,2.89,1.68,50.91,43.23,63.45,3701;
4594,51.78,67.5,61.17,51.84,11.5,44.24,3027.29,2.89,1.68,51.02,43.28,63.45,3696;
4604,51.86,67.3,61.34,51.91,11.51,44.3,2973.48,2.9,1.71,51.09,43.35,63.88,3696;
4614,52.01,67.4,61.55,52.04,11.51,44.37,2999.86,2.87,1.71,51.18,43.42,63.74,3699;
4624,52.06,67.6,61.59,52.15,11.51,44.45,3003.42,2.87,1.71,51.27,43.5,63.88,3695;
4634,52.14,67.8,61.73,52.21,11.52,44.53,3036.22,2.89,1.73,51.37,43.6,64.17,3698;
4644,52.27,67.5,61.89,52.31,11.51,44.63,2995.6,2.9,1.73,51.47,43.66,64.17,3700;
4654,52.29,67.3,61.86,52.4,11.5,44.68,3018.74,2.87,1.75,51.53,43.72,64.6,3700;
4664,52.32,67.3,61.92,52.42,11.5,44.79,3026.36,2.9,1.76,51.57,43.78,64.6,3700;
4674,52.33,67.4,61.95,52.45,11.51,44.86,3014.65,2.88,1.76,51.63,43.87,64.6,3700;
4684,52.35,67.1,61.97,52.47,11.53,44.93,2976.45,2.86,1.77,51.7,43.94,64.6,3697;
4694,52.38,67.1,61.99,52.48,11.53,44.99,3000.48,2.88,1.78,51.74,44.01,64.89,3695;
4704,52.39,67.2,62.06,52.48,11.53,45.04,3025.74,2.88,1.79,51.76,44.06,64.89,3699;
4714,52.4,67.2,62.1,52.51,11.54,45.07,2999.75,2.88,1.8,51.75,44.13,65.32,3701;
4724,52.46,67.3,62.2,52.5,11.53,45.15,2984.02,2.88,1.8,51.8,44.1,65.32,3701;
4734,52.48,67.2,62.26,52.6,11.52,45.21,3044.14,2.87,1.81,51.85,44.12,65.32,3699;
4744,52.52,67.4,62.29,52.62,11.52,45.26,2978.98,2.86,1.83,51.84,44.17,65.61,3701;
4754,52.52,67.1,62.42,52.62,11.53,45.31,3014.65,2.86,1.83,51.85,44.24,65.61,3700;
4764,52.6,67.1,62.42,52.64,11.53,45.35,3014.7,2.86,1.85,51.89,44.32,66.04,3696;
4774,52.55,67.2,62.43,52.7,11.53,45.38,2979.87,2.84,1.85,51.96,44.37,66.04,3700;
4784,52.6,67.1,62.51,52.71,11.53,45.4,3001.67,2.88,1.85,51.98,44.35,66.04,3700;
4794,52.66,67.0,62.55,52.71,11.53,45.45,2988.54,2.84,1.87,51.96,44.4,66.33,3696;
4804,52.62,67.0,62.54,52.76,11.52,45.47,3007.95,2.84,1.88,51.98,44.43,66.33,3700;
4814,52.57,67.1,62.49,52.74,11.52,45.49,3004.52,2.86,1.9,52.03,44.46,66.76,3700;
4824,52.69,66.9,62.68,52.72,11.51,45.53,2998.78,2.85,1.9,52.08,44.5,66.76,3696;
4834,52.78,67.0,62.7,52.83,11.51,45.54,3025.68,2.84,1.9,52.08,44.53,66.76,3700;
4844,52.69,66.9,62.69,52.87,11.51,45.57,3005.75,2.84,1.92,52.13,44.58,67.05,3700;
4854,52.8,67.0,62.85,52.82,11.52,45.62,3007.85,2.85,1.92,52.12,44.61,67.05,3699;
4864,52.78,66.9,62.83,52.9,11.53,45.67,3005.62,2.81,1.94,52.17,44.66,67.48,3699;
4874,52.83,66.9,62.9,52.9,11.52,45.71,2964.49,2.84,1.94,52.23,44.69,67.48,3700;
4884,52.89,67.1,62.98,52.96,11.52,45.73,3005.43,2.83,1.94,52.28,44.76,67.48,3701;
4894,52.99,67.2,63.14,53.04,11.52,45.79,3038.5,2.82,1.95,52.33,44.82,67.48,3699;
4904,53.06,67.4,63.33,53.12,11.52,45.85,2914.09,2.83,1.96,52.4,44.83,67.77,3697;
4914,53.26,67.4,63.52,53.25,11.52,45.89,3011.92,2.83,1.98,52.51,44.93,67.77,3696;
4924,53.33,67.4,63.59,53.35,11.53,45.96,3021.16,2.82,1.98,52.64,45.05,68.2,3701;
4935,53.48,67.4,63.78,53.5,11.53,46.03,2993.11,2.79,1.99,52.74,45.09,68.2,3700;
4944,53.53,67.2,63.8,53.59,11.53,46.12,3007.41,2.82,1.99,52.78,45.13,68.2,3700;
4954,53.48,67.1,63.71,53.6,11.54,46.17,2984.68,2.81,2.01,52.79,45.19,68.49,3699;
4964,53.46,67.1,63.73,53.58,11.54,46.22,3015.07,2.81,2.01,52.82,45.25,68.49,3698;
4975,53.45,67.1,63.74,53.57,11.54,46.28,2979.36,2.81,2.03,52.8,45.29,68.92,3696;
4984,53.49,67.1,63.81,53.57,11.54,46.3,3090.07,2.8,2.03,52.82,45.3,68.92,3701;
4994,53.48,67.0,63.83,53.59,11.54,46.38,2953.56,2.83,2.03,52.82,45.35,68.92,3701;
5004,53.44,66.9,63.79,53.57,11.54,46.41,3015.28,2.8,2.06,52.83,45.36,69.21,3699;
5014,53.42,66.9,63.75,53.53,11.54,46.44,3028.85,2.8,2.05,52.88,45.36,69.21,3698;
5025,53.46,66.8,63.84,53.53,11.55,46.48,3007.76,2.8,2.07,52.88,45.41,69.21,3699;
5034,53.49,66.7,63.87,53.56,11.54,46.51,2975.93,2.82,2.07,52.91,45.41,69.64,3700;
5045,53.46,66.6,63.84,53.59,11.53,46.53,3034.1,2.81,2.08,52.91,45.41,69.64,3700;
5054,53.46,66.6,63.8,53.56,11.53,46.54,3017.33,2.77,2.09,52.91,45.41,69.93,3700;
5064,53.37,66.4,63.75,53.53,11.53,46.58,2977.59,2.78,2.09,52.88,45.43,69.93,3701;
5074,53.44,66.6,63.69,53.49,11.53,46.61,3007.03,2.78,2.1,52.91,45.46,69.93,3700;
5084,53.38,66.6,63.74,53.5,11.52,46.64,2969.19,2.79,2.11,52.95,45.48,70.36,3697;
5094,53.45,66.3,63.81,53.52,11.52,46.64,2949.19,2.78,2.13,52.99,45.51,70.65,3700;
5104,53.4,66.2,63.73,53.53,11.52,46.65,2961.34,2.79,2.14,53.02,45.58,70.65,3700;
5115,53.44,66.0,63.79,53.51,11.51,46.68,2978.8,2.79,2.14,52.99,45.6,70.65,3700;
5125,53.33,66.0,63.61,53.49,11.51,46.71,2988.96,2.78,2.16,52.94,45.58,71.08,3696;
5134,53.37,66.1,63.65,53.43,11.51,46.73,3026.4,2.78,2.17,52.93,45.63,71.08,3699;
5144,53.33,66.0,63.64,53.43,11.51,46.75,3019.18,2.78,2.17,52.9,45.65,71.08,3701;
5154,53.35,65.8,63.67,53.45,11.51,46.76,2986.59,2.79,2.18,52.88,45.66,70.94,3700;
5165,53.28,65.7,63.64,53.45,11.52,46.77,3029.21,2.78,2.2,52.87,45.63,71.37,3700;
5174,53.26,65.9,63.58,53.4,11.52,46.78,2983.64,2.77,2.21,52.83,45.66,71.8,3699;
5185,53.35,65.9,63.82,53.34,11.52,46.79,3045.02,2.78,2.21,52.88,45.68,71.8,3700;
5194,53.4,66.1,63.84,53.45,11.52,46.8,2967.38,2.77,2.22,52.9,45.7,71.8,3695;
5204,53.45,66.1,63.95,53.48,11.51,46.82,3004.14,2.79,2.23,52.98,45.71,71.8,3697;
5214,53.54,66.1,64.12,53.59,11.51,46.83,2996.17,2.77,2.24,53.01,45.74,72.09,3699;
5224,53.66,66.2,64.2,53.65,11.51,46.84,3013.17,2.77,2.25,53.1,45.8,72.09,3701;
5235,53.7,66.4,64.25,53.74,11.51,46.86,2991.26,2.75,2.27,53.18,45.85,72.52,3700;
5244,53.89,66.6,64.49,53.83,11.51,46.89,2985.09,2.78,2.27,53.32,45.95,72.52,3697;
5255,54.06,67.1,64.72,54.04,11.51,46.92,3001.02,2.77,2.28,53.39,46.04,72.52,3696;
5264,54.13,66.9,64.81,54.12,11.51,46.99,3007.68,2.78,2.28,53.54,46.11,72.81,3696;
5274,54.42,67.0,65.11,54.33,11.51,47.04,2979.07,2.78,2.29,53.72,46.19,72.81,3700;
5285,54.58,67.1,65.25,54.52,11.51,47.11,3019.79,2.79,2.32,53.87,46.28,73.24,3701;
5294,54.58,67.2,65.24,54.64,11.52,47.22,3046.01,2.77,2.32,54.0,46.37,73.24,3701;
5305,54.76,67.1,65.49,54.7,11.52,47.3,3008.52,2.79,2.33,54.09,46.48,73.24,3701;
5314,54.86,67.1,65.61,54.9,11.52,47.37,3010.52,2.77,2.34,54.22,46.57,73.53,3700;
5325,54.93,67.1,65.6,54.94,11.52,47.44,3034.29,2.8,2.36,54.25,46.63,73.53,3700;
5335,55.0,67.1,65.79,55.0,11.52,47.54,3034.84,2.77,2.37,54.36,46.7,73.96,3700;
5344,55.08,67.3,65.88,55.12,11.52,47.59,2973.82,2.77,2.37,54.46,46.77,73.96,3700;
5355,55.07,67.1,65.92,55.14,11.52,47.66,3026.6,2.74,2.37,54.5,46.78,73.96,3698;
5365,55.1,67.2,65.92,55.15,11.52,47.73,3067.1,2.78,2.38,54.5,46.83,74.24,3697;
5375,55.08,67.4,66.04,55.15,11.52,47.8,2996.41,2.76,2.39,54.57,46.86,74.24,3697;
5385,55.16,67.2,66.13,55.19,11.51,47.88,3043.37,2.78,2.4,54.62,46.94,74.68,3696;
5395,55.2,67.3,66.13,55.27,11.51,47.91,2962.02,2.75,2.4,54.66,46.95,74.68,3698;
5405,55.3,67.2,66.24,55.3,11.51,47.97,2984.65,2.76,2.41,54.71,47.0,74.68,3700;
5414,55.29,67.0,66.21,55.4,11.51,48.01,3010.32,2.77,2.42,54.73,47.05,74.68,3700;
5425,55.21,67.1,66.1,55.39,11.52,48.03,3026.28,2.76,2.44,54.75,47.1,74.96,3701;
5435,55.23,67.1,66.15,55.29,11.52,48.07,3020.79,2.73,2.44,54.73,47.16,74.96,3700;
5445,55.23,67.0,66.19,55.29,11.52,48.1,2962.92,2.76,2.45,54.76,47.17,75.4,3699;
5455,55.23,67.0,66.12,55.29,11.52,48.13,3007.43,2.75,2.45,54.78,47.17,75.4,3697;
5465,55.26,66.7,66.19,55.29,11.53,48.17,2998.08,2.74,2.46,54.84,47.16,75.4,3701;
5475,55.27,66.9,66.12,55.35,11.54,48.19,2964.69,2.74,2.48,54.86,47.16,75.83,3697;
5485,55.23,66.7,66.17,55.3,11.54,48.21,3016.84,2.76,2.48,54.89,47.19,75.83,3700;
5495,55.16,66.6,66.07,55.3,11.54,48.24,2999.68,2.75,2.5,54.86,47.23,76.12,3700;
5505,55.31,66.7,66.18,55.28,11.54,48.29,3007.22,2.75,2.5,54.84,47.3,76.12,3696;
5515,55.25,66.6,66.18,55.38,11.54,48.32,3022.04,2.76,2.52,54.84,47.35,76.12,3701;
5525,55.23,66.7,66.18,55.35,11.54,48.35,3040.69,2.75,2.52,54.8,47.37,76.4,3696;
5535,55.21,66.6,66.23,55.3,11.54,48.39,2975.34,2.74,2.55,54.78,47.4,76.83,3700;
5545,55.3,66.9,66.29,55.3,11.54,48.41,3005.36,2.76,2.56,54.81,47.41,76.83,3700;
5555,55.36,66.9,66.42,55.39,11.54,48.41,3029.75,2.74,2.56,54.86,47.43,76.83,3700;
5565,55.38,66.6,66.45,55.41,11.54,48.42,3001.57,2.75,2.57,54.93,47.4,76.83,3696;
5575,55.43,66.6,66.42,55.53,11.54,48.46,3035.69,2.75,2.58,54.95,47.44,77.12,3700;
5585,55.38,66.8,66.37,55.53,11.54,48.48,2986.8,2.74,2.61,54.96,47.45,77.12,3701;
5595,55.51,66.8,66.56,55.51,11.53,48.5,2974.04,2.77,2.62,55.02,47.5,77.7,3700;
5605,55.57,66.8,66.63,55.64,11.53,48.54,3001.48,2.76,2.62,55.07,47.54,77.7,3696;
5615,55.59,66.7,66.62,55.67,11.53,48.58,3032.3,2.79,2.63,55.12,47.57,77.55,3701;
5625,55.62,66.7,66.62,55.7,11.53,48.64,3013.69,2.79,2.64,55.23,47.6,77.84,3699;
5635,55.68,66.5,66.64,55.72,11.53,48.69,3031.92,2.76,2.65,55.24,47.64,77.84,3699;
5645,55.66,66.5,66.62,55.75,11.53,48.73,2977.67,2.76,2.66,55.25,47.7,78.27,3700;
5655,55.66,66.4,66.64,55.75,11.53,48.75,2934.81,2.76,2.67,55.29,47.75,78.27,3701;
5665,55.62,66.3,66.52,55.73,11.54,48.78,2964.03,2.77,2.67,55.28,47.75,78.27,3697;
5675,55.5,66.3,66.39,55.7,11.54,48.82,2990.59,2.75,2.68,55.24,47.73,78.56,3700;
5685,55.51,66.2,66.46,55.61,11.54,48.85,3004.74,2.76,2.69,55.2,47.73,78.56,3697;
5695,55.51,66.1,66.41,55.6,11.54,48.86,2993.2,2.77,2.69,55.23,47.75,78.99,3698;
5705,55.48,66.1,66.42,55.58,11.54,48.86,3009.85,2.75,2.7,55.17,47.8,78.99,3701;
5715,55.4,65.8,66.31,55.53,11.54,48.86,2991.12,2.76,2.7,55.12,47.77,78.99,3699;
5725,55.32,65.8,66.21,55.49,11.54,48.86,3041.75,2.77,2.7,55.03,47.75,78.99,3700;
5735,55.19,65.6,66.12,55.36,11.55,48.86,3048.06,2.75,2.71,55.01,47.73,79.28,3696;
5745,55.14,65.7,66.11,55.3,11.54,48.85,2971.87,2.76,2.72,54.96,47.67,79.28,3697;
5755,55.07,65.7,65.98,55.2,11.53,48.83,2985.88,2.76,2.72,54.86,47.65,79.71,3700;
5765,55.17,65.4,66.03,55.18,11.54,48.83,2995.94,2.78,2.72,54.85,47.65,79.71,3698;
5775,55.01,65.3,65.8,55.24,11.54,48.83,3011.75,2.76,2.73,54.75,47.65,79.71,3701;
5785,54.93,65.3,65.75,55.14,11.55,48.82,2978.6,2.77,2.74,54.75,47.6,80.0,3700;
5795,54.98,65.2,65.69,55.02,11.55,48.82,2997.58,2.77,2.75,54.73,47.6,80.43,3697;
5805,54.91,65.2,65.58,55.03,11.54,48.78,3008.56,2.79,2.75,54.7,47.57,80.43,3701;
5815,54.93,65.4,65.66,54.99,11.54,48.76,3040.92,2.79,2.75,54.63,47.56,80.43,3700;
5825,54.95,65.1,65.74,54.99,11.54,48.75,2954.75,2.79,2.76,54.65,47.59,80.72,3700;
5835,55.02,65.3,65.63,55.03,11.55,48.74,3019.17,2.76,2.76,54.64,47.57,80.72,3698;
5845,55.05,65.3,65.69,55.08,11.56,48.72,2999.78,2.82,2.77,54.66,47.59,81.15,3696;
5855,55.03,65.2,65.65,55.12,11.56,48.72,3010.21,2.82,2.78,54.68,47.6,81.15,3698;
5865,55.02,65.3,65.57,55.11,11.55,48.7,3001.12,2.8,2.78,54.71,47.6,81.15,3699;
5875,54.98,65.3,65.6,55.11,11.55,48.7,3017.68,2.82,2.79,54.75,47.61,81.15,3696;
5885,55.03,65.4,65.63,55.11,11.54,48.7,3053.94,2.83,2.79,54.74,47.6,81.44,3701;
5895,55.08,65.3,65.77,55.12,11.53,48.7,2987.77,2.83,2.8,54.74,47.6,81.44,3697;
5905,55.12,65.4,65.71,55.14,11.54,48.7,2979.34,2.82,2.81,54.78,47.61,81.87,3701;
5915,55.16,65.5,65.78,55.2,11.54,48.7,3031.43,2.82,2.81,54.74,47.62,81.87,3696;
5925,55.17,65.3,65.83,55.22,11.55,48.73,2963.42,2.83,2.82,54.7,47.64,81.87,3701;
5935,55.15,65.4,65.71,55.25,11.56,48.74,2990.68,2.84,2.82,54.71,47.65,82.16,3699;
5945,55.19,65.5,65.73,55.25,11.55,48.75,2974.7,2.84,2.83,54.75,47.65,82.16,3697;
5955,55.29,65.6,65.8,55.31,11.54,48.76,3006.84,2.88,2.84,54.79,47.7,82.59,3697;
5965,55.31,65.7,65.92,55.36,11.54,48.78,2964.76,2.86,2.83,54.84,47.71,82.59,3700;
5975,55.42,65.6,65.96,55.38,11.54,48.79,2976.06,2.85,2.83,54.89,47.75,82.59,3700;
5985,55.45,65.4,66.0,55.52,11.54,48.8,2994.62,2.85,2.84,54.97,47.8,82.88,3701;
5995,55.52,65.8,66.06,55.52,11.54,48.81,2972.7,2.87,2.84,54.97,47.83,82.88,3696;
6005,55.56,65.9,66.06,55.58,11.53,48.86,3013.17,2.89,2.85,55.07,47.87,83.31,3701;
6015,55.64,66.0,66.22,55.68,11.53,48.88,2999.63,2.87,2.85,55.15,47.92,83.31,3698;
6025,55.78,66.0,66.38,55.73,11.53,48.93,2969.12,2.87,2.84,55.26,47.92,83.31,3699;
6035,55.8,65.6,66.31,55.85,11.52,48.97,2963.97,2.88,2.85,55.34,47.98,83.31,3700;
6045,55.73,65.9,66.24,55.87,11.53,49.04,2991.07,2.86,2.86,55.26,48.05,83.6,3699;
6055,55.66,65.9,66.21,55.77,11.53,49.06,2967.84,2.91,2.86,55.24,48.04,83.6,3700;
6065,55.67,65.7,66.22,55.75,11.53,49.07,3013.92,2.89,2.87,55.22,48.03,84.03,3698;
6075,55.68,66.0,66.19,55.78,11.53,49.07,2969.41,2.89,2.87,55.19,48.03,84.03,3699;
6085,55.73,65.8,66.33,55.73,11.53,49.07,3050.81,2.9,2.88,55.24,48.01,84.46,3697;
6095,55.67,65.5,66.22,55.76,11.53,49.07,2975.77,2.92,2.88,55.17,48.05,84.46,3696;
6105,55.66,65.5,66.05,55.76,11.53,49.08,3015.22,2.92,2.88,55.17,48.06,84.46,3700;
6115,55.57,65.4,65.97,55.7,11.53,49.1,2989.38,2.9,2.89,55.15,48.05,84.46,3699;
6125,55.51,65.1,65.94,55.67,11.53,49.11,3008.72,2.9,2.89,55.07,48.04,84.75,3700;
6135,55.34,65.0,65.68,55.61,11.53,49.12,2974.33,2.92,2.89,54.96,48.04,84.75,3699;
6146,55.24,64.8,65.54,55.42,11.52,49.12,3020.24,2.92,2.89,54.92,47.98,85.04,3698;
6155,55.1,64.9,65.36,55.36,11.52,49.11,3008.36,2.92,2.9,54.89,47.94,85.04,3698;
6165,55.17,64.9,65.36,55.18,11.51,49.05,2999.85,2.92,2.9,54.84,47.9,85.47,3698;
6176,55.1,64.9,65.31,55.21,11.51,49.03,3001.42,2.91,2.91,54.79,47.89,85.47,3701;
6185,55.12,65.0,65.3,55.18,11.51,49.02,2973.32,2.91,2.9,54.76,47.9,85.47,3701;
6195,55.07,64.9,65.28,55.18,11.52,49.0,2993.18,2.94,2.91,54.75,47.89,85.76,3693;
6205,55.07,64.7,65.23,55.16,11.52,48.98,2988.52,2.94,2.92,54.71,47.87,85.76,3695;
6216,55.01,64.8,65.09,55.15,11.52,48.97,3050.12,2.95,2.92,54.68,47.87,86.19,3695;
6225,55.07,64.8,65.21,55.1,11.52,48.95,2983.59,2.95,2.93,54.65,47.82,86.19,3697;
6236,55.07,64.9,65.16,55.11,11.52,48.96,3017.66,2.92,2.93,54.68,47.85,86.19,3697;
6245,55.14,64.7,65.27,55.14,11.53,48.96,2997.59,2.96,2.93,54.71,47.85,86.47,3699;
6255,55.1,64.8,65.22,55.19,11.52,48.96,3011.75,2.96,2.94,54.68,47.83,86.47,3698;
6266,55.1,64.8,65.25,55.15,11.52,48.96,2973.87,2.95,2.94,54.62,47.85,86.91,3694;
6275,55.05,64.7,65.17,55.15,11.53,48.95,2975.86,2.94,2.94,54.58,47.83,86.91,3691;
6286,55.07,64.5,65.2,55.11,11.53,48.95,3040.6,2.97,2.95,54.58,47.82,86.91,3695;
6295,55.0,64.5,65.02,55.12,11.53,48.97,2996.82,2.97,2.95,54.53,47.78,87.19,3692;
6306,54.9,64.4,64.93,55.04,11.53,48.97,3004.65,2.98,2.95,54.48,47.75,87.19,3693;
6315,54.85,64.5,64.86,54.99,11.52,48.96,2982.83,2.97,2.95,54.48,47.73,87.63,3691;
6325,54.86,64.5,64.85,54.94,11.52,48.94,2984.55,2.96,2.95,54.43,47.75,87.63,3690;
6335,54.85,64.4,64.82,54.95,11.52,48.92,3051.61,3.0,2.95,54.42,47.73,87.63,3691;
6345,54.85,64.5,64.86,54.92,11.51,48.89,2970.1,2.97,2.96,54.41,47.73,87.91,3691;
6356,54.87,64.4,64.82,54.92,11.51,48.87,2984.06,2.96,2.96,54.41,47.73,87.91,3691;
6365,54.91,64.4,64.86,54.96,11.51,48.85,3022.3,2.99,2.96,54.42,47.68,88.35,3689;
6376,54.85,64.3,64.76,54.98,11.51,48.85,2975.27,2.98,2.97,54.41,47.68,88.35,3692;
6385,54.86,64.4,64.79,54.96,11.51,48.85,3008.37,3.01,2.97,54.37,47.71,88.35,3691;
6395,54.93,64.4,64.82,54.93,11.51,48.85,3014.13,2.96,2.97,54.41,47.7,88.35,3684;
6405,54.85,64.3,64.77,54.98,11.52,48.85,2959.9,2.98,2.97,54.42,47.68,88.63,3685;
6415,54.82,64.2,64.68,54.95,11.53,48.85,3007.44,3.02,2.98,54.37,47.68,88.63,3684;
6426,54.71,64.1,64.57,54.87,11.52,48.85,2999.98,3.0,2.97,54.3,47.66,89.06,3681;
6435,54.65,63.9,64.52,54.75,11.51,48.84,2984.16,3.0,2.98,54.25,47.65,89.06,3683;
6445,54.64,63.8,64.52,54.72,11.52,48.83,2997.63,2.99,2.98,54.18,47.64,89.06,3685;
6455,54.51,63.8,64.35,54.69,11.52,48.82,2971.33,3.01,2.98,54.11,47.6,89.35,3683;
6465,54.41,63.5,64.21,54.57,11.52,48.79,2965.05,3.0,2.98,54.05,47.55,89.35,3678;
6476,54.3,63.5,64.05,54.51,11.52,48.77,2984.17,3.02,2.99,53.97,47.49,89.78,3678;
6486,54.27,63.5,63.99,54.37,11.52,48.72,2954.74,3.02,2.99,53.94,47.45,89.78,3682;
6496,54.25,63.5,63.98,54.34,11.52,48.67,2947.53,3.01,2.99,53.87,47.4,89.78,3680;
6505,54.17,63.2,63.92,54.28,11.52,48.61,3006.42,3.02,2.99,53.82,47.35,90.07,3680;
6516,54.13,63.2,63.86,54.26,11.52,48.59,3021.9,3.05,2.99,53.8,47.34,90.07,3681;
6526,54.03,63.4,63.65,54.14,11.52,48.5,2979.88,3.01,3.0,53.76,47.32,90.5,3679;
6535,54.05,63.3,63.72,54.1,11.51,48.46,2974.19,2.99,3.0,53.71,47.28,90.5,3677;
6545,54.16,63.3,63.75,54.1,11.51,48.43,3039.11,3.04,3.0,53.78,47.29,90.5,3675;
6555,54.11,63.5,63.79,54.21,11.51,48.41,3020.08,3.01,3.0,53.77,47.27,90.79,3674;
6566,54.22,63.5,63.89,54.21,11.51,48.4,2949.4,3.02,3.01,53.8,47.3,90.79,3680;
6576,54.26,63.2,63.94,54.26,11.51,48.4,2910.51,3.02,3.01,53.87,47.32,91.22,3674;
6586,54.22,63.4,63.81,54.32,11.51,48.4,3053.51,3.01,3.01,53.87,47.32,91.22,3674;
6595,54.14,63.3,63.81,54.23,11.51,48.4,3015.2,3.01,3.01,53.75,47.32,91.22,3674;
6605,54.1,63.3,63.81,54.17,11.5,48.39,2996.47,3.03,3.01,53.72,47.28,91.51,3671;
6616,54.09,63.3,63.72,54.16,11.5,48.37,3019.3,3.02,3.01,53.64,47.24,91.51,3675;
6625,54.09,63.2,63.76,54.13,11.5,48.35,2997.14,3.03,3.01,53.67,47.22,91.94,3672;
6636,54.03,63.2,63.66,54.14,11.5,48.32,3004.84,3.04,3.01,53.65,47.19,91.94,3674;
6645,54.03,63.2,63.66,54.12,11.49,48.28,2985.64,3.04,3.01,53.6,47.17,91.94,3674;
6656,53.97,63.2,63.57,54.07,11.49,48.27,3036.24,3.02,3.01,53.58,47.16,92.23,3670;
6666,53.95,63.1,63.54,54.02,11.48,48.25,3029.99,3.03,3.02,53.51,47.14,92.23,3672;
6676,53.92,63.2,63.52,54.0,11.48,48.25,3029.73,3.02,3.02,53.48,47.1,92.66,3667;
6686,53.97,63.2,63.54,54.01,11.48,48.24,2973.94,3.04,3.02,53.51,47.1,92.66,3671;
6696,53.95,63.1,63.55,54.02,11.47,48.22,2988.86,3.04,3.03,53.49,47.1,92.66,3670;
6706,54.03,63.2,63.64,54.02,11.48,48.21,3013.22,3.03,3.03,53.49,47.1,92.66,3674;
6716,54.03,63.2,63.55,54.09,11.49,48.2,2976.02,3.05,3.03,53.5,47.14,92.95,3670;
6726,54.01,63.2,63.59,54.09,11.49,48.19,2950.5,3.07,3.03,53.54,47.14,92.95,3668;
6736,54.17,63.3,63.73,54.11,11.5,48.19,3019.98,3.04,3.03,53.62,47.19,93.24,3664;
6746,54.21,63.4,63.78,54.25,11.51,48.21,2960.92,3.06,3.03,53.64,47.17,93.38,3663;
6756,54.26,63.3,63.82,54.26,11.51,48.21,2949.16,3.06,3.04,53.7,47.19,93.67,3666;
6766,54.28,63.4,63.82,54.32,11.5,48.24,3053.58,3.05,3.04,53.75,47.22,93.67,3666;
6776,54.24,63.4,63.78,54.31,11.5,48.24,3023.04,3.04,3.04,53.72,47.23,94.1,3667;
6786,54.2,63.4,63.81,54.28,11.5,48.25,2984.03,3.07,3.04,53.66,47.22,94.1,3667;
6796,54.09,63.5,63.69,54.25,11.5,48.26,3014.81,3.05,3.04,53.62,47.19,94.1,3663;
6806,54.14,63.5,63.77,54.18,11.49,48.25,2997.62,3.07,3.04,53.62,47.17,94.1,3666;
6816,54.22,63.5,63.91,54.24,11.49,48.24,2953.48,3.08,3.04,53.61,47.22,94.39,3663;
6826,54.27,63.4,63.88,54.3,11.5,48.24,2984.19,3.06,3.04,53.66,47.22,94.39,3660;
6836,54.28,63.5,63.84,54.36,11.5,48.24,3028.1,3.07,3.04,53.7,47.24,94.39,3666;
6846,54.28,63.7,63.93,54.33,11.49,48.24,2970.32,3.06,3.04,53.75,47.22,94.82,3666;
6856,54.31,63.8,64.03,54.35,11.49,48.24,3031.54,3.07,3.04,53.77,47.23,94.82,3666;
6866,54.44,63.7,64.1,54.37,11.49,48.25,2955.12,3.06,3.04,53.82,47.22,95.11,3662;
6876,54.51,63.7,64.15,54.53,11.49,48.27,2962.48,3.08,3.04,53.87,47.25,95.11,3658;
6886,54.53,63.6,64.12,54.57,11.49,48.3,3000.08,3.06,3.04,53.92,47.28,95.11,3667;
6896,54.48,63.7,64.08,54.58,11.48,48.32,3004.06,3.07,3.05,53.91,47.3,95.54,3665;
6906,54.51,63.6,64.1,54.54,11.48,48.34,3006.8,3.06,3.04,53.94,47.33,95.54,3661;
6916,54.51,63.6,64.08,54.57,11.49,48.35,2971.62,3.09,3.05,53.92,47.35,95.83,3663;
6926,54.43,63.5,63.99,54.55,11.48,48.38,2975.33,3.06,3.05,53.92,47.37,95.83,3664;
6936,54.41,63.4,63.96,54.53,11.48,48.39,2997.52,3.08,3.05,53.92,47.35,96.26,3661;
6946,54.36,63.2,63.86,54.46,11.48,48.4,3001.52,3.05,3.05,53.89,47.37,96.26,3663;
6956,54.24,63.0,63.82,54.43,11.48,48.41,3015.98,3.08,3.05,53.76,47.35,96.26,3658;
6966,54.06,62.8,63.56,54.31,11.48,48.41,2983.72,3.06,3.05,53.66,47.29,96.26,3662;
6976,53.83,62.8,63.24,54.08,11.47,48.4,2991.79,3.06,3.05,53.53,47.22,96.55,3660;
6986,53.83,62.8,63.27,53.95,11.47,48.37,2990.74,3.05,3.05,53.48,47.17,96.55,3663;
6996,53.82,62.8,63.27,53.89,11.48,48.34,3018.88,3.06,3.05,53.38,47.12,96.98,3662;
7006,53.77,62.8,63.25,53.86,11.47,48.29,3022.65,3.09,3.05,53.32,47.08,96.98,3663;
7016,53.7,62.9,63.16,53.85,11.46,48.25,2965.81,3.07,3.05,53.28,47.0,96.98,3662;
7026,53.72,62.7,63.18,53.84,11.46,48.21,3000.47,3.06,3.06,53.28,47.05,97.27,3658;
7036,53.75,62.7,63.15,53.84,11.46,48.15,2986.2,3.06,3.06,53.21,47.03,97.27,3659;
7046,53.73,62.9,63.14,53.82,11.46,48.12,2976.69,3.06,3.05,53.21,47.0,97.84,3661;
7056,53.76,62.9,63.15,53.83,11.46,48.1,2993.27,3.07,3.06,53.23,46.98,97.84,3663;
7066,53.92,62.8,63.39,53.89,11.47,48.07,3006.09,3.07,3.06,53.26,47.01,97.84,3660;
7076,53.92,62.9,63.31,53.97,11.48,48.07,2978.75,3.06,3.06,53.33,47.05,97.84,3663;
7086,53.92,62.8,63.39,53.99,11.47,48.08,2998.28,3.07,3.06,53.37,47.05,98.13,3660;
7096,53.89,62.9,63.27,53.98,11.47,48.1,2980.31,3.07,3.05,53.35,47.05,98.13,3659;
7106,53.9,62.8,63.32,53.93,11.46,48.13,3016.67,3.07,3.05,53.38,47.08,98.56,3660;
7116,53.77,62.8,63.18,53.97,11.46,48.13,2964.26,3.06,3.06,53.42,47.05,98.56,3660;
7126,53.82,62.7,63.25,53.87,11.44,48.13,3065.51,3.08,3.06,53.42,47.05,98.56,3660;
7136,53.82,62.5,63.14,53.88,11.45,48.13,2973.69,3.09,3.06,53.33,47.01,98.85,3656;
7146,53.61,62.5,62.98,53.86,11.45,48.11,3025.04,3.07,3.06,53.26,46.94,98.85,3660;
7156,53.61,62.4,62.98,53.73,11.45,48.1,3042.82,3.08,3.06,53.18,46.93,98.85,3660;
7166,53.5,62.6,62.87,53.67,11.45,48.08,2980.38,3.08,3.05,53.07,46.91,99.14,3661;
7176,53.46,62.6,62.88,53.56,11.45,48.06,2951.42,3.08,3.06,53.01,46.88,99.42,3661;
7186,53.55,62.5,62.95,53.54,11.45,48.02,2991.92,3.07,3.06,53.02,46.84,99.42,3658;
7197,53.55,62.5,62.95,53.6,11.45,47.99,2996.02,3.07,3.06,52.99,46.88,100.0,3660;
7206,53.49,62.5,62.9,53.6,11.45,47.98,2932.11,3.07,3.05,52.96,46.83,97.41,3663;
7216,53.5,62.4,62.91,53.58,11.45,47.97,2973.45,3.05,3.03,52.96,46.82,85.04,3665;
7226,53.33,62.4,62.83,53.55,11.46,47.94,2967.73,2.96,2.85,52.95,46.78,75.4,3700;
7236,52.94,62.2,62.75,53.23,11.46,47.92,3062.22,2.76,2.36,52.82,46.73,67.63,3699;
7246,52.45,62.3,62.06,53.02,11.46,47.88,2939.95,2.9,1.68,52.3,46.58,52.09,3701;
7256,51.66,62.0,58.41,51.85,11.47,47.84,3005.76,2.99,0.93,51.35,46.25,41.87,3682;
7266,51.04,61.5,53.96,49.79,11.45,47.57,2997.75,3.19,0.4,49.8,45.68,34.39,3543;
7276,50.75,61.2,52.28,48.77,11.45,47.3,2956.47,3.61,0.12,47.82,44.76,27.19,3437;
7286,50.76,61.1,47.09,44.98,11.43,46.72,3004.82,3.91,0.02,45.44,43.57,11.51,3408;
7296,50.76,61.1,43.19,41.65,11.42,46.23,3009.89,3.83,0.0,42.98,42.25,4.6,3432;
7306,50.78,61.1,39.91,38.54,11.41,45.26,3007.91,2.69,0.0,40.51,40.84,1.44,3405;
7316,50.82,61.0,36.02,34.84,11.39,44.45,3026.38,3.93,0.0,38.14,39.4,1.44,3409;
7326,50.81,60.9,33.48,32.4,11.37,42.97,3025.29,3.92,0.0,35.95,38.03,1.44,3425;
7337,50.8,60.8,30.87,29.87,11.36,41.87,2992.81,3.92,0.0,33.94,36.71,1.44,3395;
7346,50.8,60.8,30.12,29.14,11.33,40.35,3041.97,3.92,0.0,32.07,35.54,1.44,3404;
7356,50.75,60.7,26.61,25.77,11.32,39.58,2970.03,3.92,0.0,30.38,34.3,1.87,3427;
7367,50.67,60.5,25.04,24.26,11.3,37.83,2991.14,3.92,0.0,28.87,33.16,2.3,3413;
7376,50.59,60.4,24.51,23.75,11.29,36.72,2992.51,3.92,0.0,27.46,32.14,2.3,3411;
7386,50.52,60.3,22.14,21.47,11.28,35.55,3027.34,3.92,0.0,26.23,31.19,2.16,3451;
7396,50.44,60.2,21.32,20.69,11.26,34.33,2995.96,3.92,0.0,25.1,30.28,2.45,3449;
7407,50.36,60.1,20.6,19.98,11.24,33.38,3005.3,3.92,0.0,24.09,29.5,2.45,3416;
7417,50.3,60.0,19.31,18.74,11.23,32.58,2997.09,3.92,0.0,23.14,28.8,2.73,3398;
7426,50.22,59.9,18.52,18.0,11.22,31.54,3032.75,3.48,0.0,22.31,28.1,2.73,3424;
7436,50.16,59.7,17.99,17.48,11.21,30.28,3010.66,3.83,0.0,21.57,27.39,2.73,3408;
7446,50.08,59.6,17.08,16.61,11.2,29.61,3004.5,3.82,0.0,20.91,26.73,3.02,3407;
7457,50.02,59.5,16.66,16.2,11.19,28.69,2988.15,3.33,0.0,20.26,26.15,3.45,3406;
7466,49.97,59.4,16.28,15.84,11.17,27.97,3025.91,1.65,0.0,19.71,25.65,3.45,3428;
7477,49.91,59.2,15.72,15.3,11.17,27.36,3034.71,2.71,0.0,19.19,25.2,3.45,3419;
7486,49.83,59.1,15.22,14.84,11.16,26.85,2995.79,3.9,0.0,18.74,24.71,3.74,3419;
7496,49.78,59.0,14.95,14.58,11.16,26.18,3014.96,3.9,0.0,18.33,24.23,3.74,3404;
7507,49.72,58.8,14.55,14.19,11.15,25.48,3017.06,3.77,0.0,17.94,23.79,4.17,3401;
7516,49.65,58.7,14.16,13.81,11.13,24.97,3031.8,3.82,0.0,17.56,23.44,4.17,3408;
7527,49.6,58.6,13.96,13.61,11.12,24.67,2975.97,3.77,0.0,17.22,22.98,4.17,3442;
7536,49.54,58.5,13.86,13.52,11.11,24.21,2987.7,3.81,0.0,16.93,22.6,4.17,3455;
7547,49.51,58.4,13.47,13.14,11.11,23.72,3019.04,3.79,0.0,16.64,22.16,4.6,3432;
7557,49.44,58.2,13.25,12.94,11.1,23.23,3046.61,3.78,0.0,16.42,21.83,4.6,3436;
7567,49.37,58.1,13.17,12.87,11.09,22.84,2999.23,3.8,0.0,16.17,21.55,4.6,3413;
7577,49.28,58.0,12.96,12.66,11.09,22.55,3043.28,3.82,0.0,15.92,21.3,4.89,3413;
7586,49.26,57.9,12.76,12.48,11.09,22.19,2996.07,3.92,0.0,15.73,21.02,5.32,3420;
7597,49.21,57.8,12.66,12.38,11.08,21.79,2988.48,3.77,0.0,15.53,20.76,5.32,3412;
7606,49.15,57.6,12.54,12.24,11.07,21.47,3020.32,3.75,0.0,15.35,20.56,5.32,3415;
7617,49.07,57.5,12.36,12.09,11.07,21.16,3030.38,3.77,0.0,15.17,20.32,5.61,3441;
7627,49.03,57.4,12.31,12.01,11.07,20.85,2994.08,3.74,0.0,15.01,20.07,5.61,3418;
7637,48.98,57.3,12.18,11.89,11.07,20.61,2964.86,3.78,0.0,14.86,19.88,5.9,3420;
7647,48.92,57.2,12.05,11.79,11.07,20.41,3018.21,3.71,0.0,14.71,19.72,5.9,3413;
7656,48.87,57.0,12.03,11.75,11.07,20.25,3007.66,3.7,0.0,14.58,19.53,5.9,3384;
7667,48.82,56.9,11.92,11.65,11.06,19.89,3005.75,3.74,0.0,14.45,19.33,5.9,3428;
7677,48.77,56.8,11.84,11.56,11.05,19.62,3009.07,3.9,0.0,14.33,19.1,6.47,3387;
7687,48.72,56.6,11.77,11.51,11.05,19.48,3020.61,3.8,0.0,14.22,18.96,6.47,3423;
7697,48.65,56.5,11.76,11.47,11.05,19.25,3006.09,3.84,0.0,14.12,18.8,6.47,3405;
7706,48.6,56.4,11.65,11.41,11.05,19.02,3004.88,3.71,0.0,14.0,18.61,6.76,3409;
7717,48.55,56.3,11.63,11.36,11.04,18.92,3006.92,3.77,0.0,13.91,18.43,7.05,3398;
7727,48.5,56.2,11.6,11.32,11.04,18.66,2989.56,3.81,0.0,13.84,18.23,6.91,3408;
7737,48.44,56.0,11.5,11.26,11.04,18.53,3006.92,3.74,0.0,13.72,18.08,7.19,3400;
7747,48.38,55.9,11.48,11.22,11.04,18.39,2985.21,3.65,0.0,13.64,17.94,7.19,3425;
7757,48.34,55.8,11.44,11.18,11.03,18.24,2966.35,3.77,0.0,13.56,17.8,7.19,3395;
7767,48.29,55.7,11.4,11.15,11.02,18.06,3038.24,3.69,0.0,13.48,17.66,7.48,3403;
7777,48.23,55.6,11.36,11.12,11.02,17.95,3014.25,3.85,0.0,13.38,17.52,7.77,3429;
7787,48.19,55.5,11.36,11.1,11.03,17.75,2967.59,3.91,0.0,13.32,17.4,7.77,3423;
7796,48.14,55.4,11.32,11.05,11.02,17.6,2994.13,3.71,0.0,13.26,17.29,8.06,3427];
  // Measured data for ramp with a volume flow of 3000 m^3/h in the air canal;

  annotation (
    Icon(coordinateSystem(preserveAspectRatio=false)),
    Diagram(coordinateSystem(preserveAspectRatio=false)),
    Documentation(info="<html><h4>
  Data of a ramp experiment with the air handling unit 2 (AHU2)
  Preheater
</h4>
<p>
  This record contains the measured data of a ramp experiment of the
  three way valve. The investigated system is a preheater of an air
  handling unit (air handling unit 2 of the E.ON ERC test hall (Data:
  'ZUGABE_20180108_141217_measurement')).
</p>
<p>
  The heating register is supplied by a mixing circuit with a
  three-way-valve.
</p>
<p>
  During the experiment the three-way-valve is slowly openend.
</p>
<p>
  The experiment is performed with an air volume flow of 3000m^3/h and
  a pump frequency of 3700 1/min.
</p>
<p>
  The record contains the following data points (columns):
</p>
<p>
  [1: Timestep | 2: 'AHU2.Ph.SenTempReFE.T' | 3:
  'AHU2.Ph.SenTempFlFe.T' | 4: 'AHU2.Ph.SenTempFlHeBel.T' | 5:
  'AHU2.Ph.SenTempReHeBel.T' | 6: 'AHU2.Ph.SenPTHEn.T' | 7:
  'AHU2.Ph.SenPTHEx.T' | 8: 'AHU2.Ac.SenVFSupA.VFout' | 9:
  'AHU2.Ph.SenBelVFWa.VF' | 10: 'AHU2.Ph.SenMFM.VF' | 11:
  'AHU2.Ph.TempF.T33' | 12: 'AHU2.Ph.TempF.T12' | 13:
  'AHU2.Ph.Valve3W.ValvePosAct | 14: 'AHU2.Ph.PumpComp.RevcAct']
</p>
</html>"));
end AHU2_Preheater_RampValve;
